/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard;

import java.util.HashMap;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.ProcessBean;

/**
 *  Interface for building Definitions from 
 *  a "Business user" perspective
 * 
 * @author nfleury
 *
 */
public class DefinitionBuilder {
	
	private DefinitionsBean definition;
	
	//Quick reference access
	private HashMap<String,ProcessBean> processes;
	private HashMap<String,CollaborationBean> collaborations;
	
	private HashMap<String,ParticipantBean> pools;
	private HashMap<String,LaneBean> lanes;
	
	public DefinitionBuilder() {
		
		this.definition = new DefinitionsBean(IdGenerator.createUniqueId());
		
		this.processes 		= new HashMap<String, ProcessBean>();
		this.collaborations = new HashMap<String, CollaborationBean>();
		this.pools 			= new HashMap<String, ParticipantBean>();
		this.lanes 			= new HashMap<String, LaneBean>();
		
		CollaborationBean collaboration = new CollaborationBean(IdGenerator.createUniqueId());
		
		this.collaborations.put(collaboration.getId(), collaboration);
		
	}
	
	
	public ParticipantBean createPool(String poolId,String poolName){
		
		ParticipantBean result = new ParticipantBean(poolId);
		result.setName(poolName);

//		PartnerRoleBean pr = new PartnerRoleBean(DefinitionsHelper.getInstance().createUniqueId());
//		pr.setName(result.getName());
//		participant.setPartnerRole(pr);
//		result.setParticipant(participant);
		
		
		ProcessBean process = new ProcessBean(IdGenerator.createUniqueId());
		process.setName(result.getName().replace(" ","")+"Process");
		process.setType(ProcessTypes.NONE);
		result.setProcess(process);
		
		LaneSetBean laneSet = new LaneSetBean(IdGenerator.createUniqueId());
		process.addLaneSet(laneSet);
		
		
		//Add the created process
		this.processes.put(process.getId(), process);
		
		
		//for now we consider that even if we have only one 
		//process, we will create a collaboration
		
		
		//TODO: if we have more than one process we have a collaboration
		
		
		
		return result;
	}
	
	
	public void addLane(String poolId,LaneBean lane){
		
		
		
	}
	
	
	public void addFlowElement(String laneId,FlowElementBean flowElement){
		
	}
	
	
	
	
	public DefinitionsBean getDefinition() {
		return definition;
	}
	
	
	public ParticipantBean getPoolById(String id){
		return this.pools.get(id);
	}
	
	public LaneBean getLaneById(String id){
		return this.lanes.get(id);
	}
	
	
	
}
