/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ChoreographyLoopType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;

public abstract class ChoreographyActivityBean extends FlowNodeBean implements IChoreographyActivityBean{

    private List<IParticipantBean> participants;
    private IParticipantBean initiatingParticipant;
    private ChoreographyLoopType choreographyLoopType;
    
    protected ChoreographyActivityBean(){
        super();
        participants = new ArrayList<IParticipantBean>();
        choreographyLoopType = ChoreographyLoopType.None;
    }
    
    public ChoreographyActivityBean(String id){
        super(id);
        participants = new ArrayList<IParticipantBean>();
        choreographyLoopType = ChoreographyLoopType.None;
    }
    
    public void addParticipantBean(IParticipantBean p){
        participants.add(p);
    }
    
    public void removeParticipantBean(IParticipantBean p){
        participants.remove(p);
    }
    ////////////////////////////////////////////
    /////                                  /////
    /////       GETTERS AND SETTERS        /////
    /////                                  /////
    ////////////////////////////////////////////
    public List<IParticipantBean> getParticipants() {
        return participants;
    }
    public void setParticipants(List<IParticipantBean> ParticipantBeans) {
        this.participants = ParticipantBeans;
    }
    public IParticipantBean getInitiatingParticipant() {
        return initiatingParticipant;
    }
    public void setInitiatingParticipant(IParticipantBean initiatingParticipantBean) {
        this.initiatingParticipant = initiatingParticipantBean;
    }
    public ChoreographyLoopType getChoreographyLoopType() {
        return choreographyLoopType;
    }
    public void setChoreographyLoopType(ChoreographyLoopType choreographyLoopType) {
        this.choreographyLoopType = choreographyLoopType;
    }
}
