/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IPartnerRoleBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;


public class PartnerRoleBean extends BaseElementBean implements IPartnerRoleBean {

	private String name;
	private List<IParticipantBean> participants;

	public PartnerRoleBean(String id){
		super(id);
		setParticipants(new ArrayList<IParticipantBean>());
	}
	
	protected PartnerRoleBean(){
		super();
		setParticipants(new ArrayList<IParticipantBean>());
	}
	
	public void addParticipant(IParticipantBean p){
		participants.add(p);
	}
	
	public void removeParticipant(IParticipantBean p){
		participants.remove(p);
	}
	
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setParticipants(List<IParticipantBean> participants) {
		this.participants = participants;
	}

	public List<IParticipantBean> getParticipants() {
		return participants;
	}
	
	@Override
	public String toString() {
		return getName();
	}

}
