/**
 * bpel-export-client - BPEL Export integration test - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.BPELExampleGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsBeanVisitor;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.FileInformationNode;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.MappingInformation;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.repository.FileRepositoryDescription;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.Icons;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.MappingWindow;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.assign.DragAndDropGroup;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.BPELExportPageChangeListener;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.service.governance.PetalsMasterDescription;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.RootPanel;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;


/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Application implements EntryPoint {

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() { 

		Button b1 = new Button("classic", new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				List<FileRepositoryDescription> l = new ArrayList<FileRepositoryDescription>();
				l.add(new PetalsMasterDescription());
				l.add(new FakeRepositoryDescription());
				new MappingWindow(BPELExampleGenerator.getExample(),"FAKE_ID3", new BPELExportPageChangeListener(), l).show();
			}
		});
		RootPanel.get().add(b1);

		
		Button b2 = new Button("No upload", new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				new MappingWindow(BPELExampleGenerator.getExample(),"FAKE_ID4", new FakeNoUploadPageChangeListener()).show();
			}
		});
		RootPanel.get().add(b2);
		
		
		Button b3 = new Button("No repo", new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				new MappingWindow(BPELExampleGenerator.getExample(),"FAKE_ID5", new BPELExportPageChangeListener()).show();
			}
		});
		RootPanel.get().add(b3);
		
		Button b4 = new Button("Close Window", new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				new MappingWindow(BPELExampleGenerator.getExample(),"FAKE_ID6", new CloseWindowPageChangeListener()).show();
			}
		});
		RootPanel.get().add(b4);
		
		Button b5 = new Button("Started mapping", new ButtonListenerAdapter(){
            public void onClick(Button button, EventObject e) {
                DefinitionsBean defs = BPELExampleGenerator.getExample();
                
                List<FileInformationNode> mappedNodes = new ArrayList<FileInformationNode>();
                FileInformationNode parent = new FileInformationNode("PLOParent", Icons.BIN_ICON, null);
                final MappingInformation info = new FakeMappingInfo("associatedInfo");
                FileInformationNode fin = new FileInformationNode("PLOP", Icons.BIN_ICON, info, DragAndDropGroup.TASK, parent);
                parent.addChild(fin);
                mappedNodes.add(parent);

                final Map<String,MappingInformation> mapping = new HashMap<String, MappingInformation>();
                try {
                    new DefinitionsBeanVisitor(defs) {
                        private boolean first = true;
                        @Override
                        public void visitTask(ITaskBean t){
                            if(first){
                                mapping.put(t.getId(), info);
                                first = false;
                            }
                        }
                    }.visitDefinitionsByPools();
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
                
                new MappingWindow(defs,"FAKE_ID7", new BPELExportPageChangeListener(),new ArrayList<FileRepositoryDescription>(),mapping,mappedNodes).show();
            }
        });
        RootPanel.get().add(b5);
	}
	
	
	private class FakeMappingInfo implements MappingInformation{
        private String s;
        public FakeMappingInfo(String s) {
            this.setS(s);
        }
        protected FakeMappingInfo(){}
        public void setS(String s) {
            this.s = s;
        }
        public String getS() {
            return s;
        }
    }
	
}
