/**
 * bpel-export-client - BPEL Export integration test - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.FileInformationNode;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.MappingInformation;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.Icons;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.NoUploadPageChangeListener;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.assign.AssignmentEndCallBack;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.assign.AssignmentPanel;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.assign.DragAndDropGroup;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.upload.InformationExtractionCallback;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.service.WSDLReadingService;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.service.WSDLReadingServiceAsync;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.service.to.WSDLInfoList;
import com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client.ui.WSDLIcons;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.Label;


public class FakeNoUploadPageChangeListener implements NoUploadPageChangeListener{

	
	public void getFileInformation(String userId, final InformationExtractionCallback callback) {
		final List<FileInformationNode> l = new ArrayList<FileInformationNode>();
		
		FileInformationNode fin = new FileInformationNode("PLOP", Icons.BIN_ICON, new FakeMappingInfo("associatedInfo"));
		l.add(fin);
		
		Set<DragAndDropGroup> set = new HashSet<DragAndDropGroup>();
		set.add(DragAndDropGroup.START_EVENT);
		set.add(DragAndDropGroup.TASK);
		FileInformationNode fin2 = new FileInformationNode("PLIP", Icons.LANE_ICON, new FakeMappingInfo("anotherinfo"), set,  fin);
		fin.addChild(fin2);
		
		Set<DragAndDropGroup> set2 = new HashSet<DragAndDropGroup>();
		set2.add(DragAndDropGroup.LANE);
		FileInformationNode fin3 = new FileInformationNode("PLAP", WSDLIcons.MESSAGE_ICON, new FakeMappingInfo("tinyInfo"), 
				set2, fin);
		fin.addChild(fin3);
		
		FileInformationNode fin4 = new FileInformationNode("PLUP", WSDLIcons.ARROW_LEFT_ICON, new FakeMappingInfo("uselessInfo"),fin);
		fin.addChild(fin4);
		
		WSDLReadingServiceAsync service = (WSDLReadingServiceAsync) GWT.create(WSDLReadingService.class);
		service.getWSDLInfo(userId, new AsyncCallback<WSDLInfoList>() {
			public void onSuccess(WSDLInfoList arg0) {
				callback.onInformationRetrieved(l);
			}
			public void onFailure(Throwable arg0) {
				callback.onInformationRetrieved(l);
			}
		});
	}

	
	public void onAssignmentEnd(String userId, DefinitionsBean defs,
			AssignmentPanel assignmentPanel, AssignmentEndCallBack callback) {
		
		if(assignmentPanel.areAllMapped(LaneBean.class) && assignmentPanel.areAllMapped(StartEventBean.class)){
			Panel p = new Panel("It's all good folks !");
			p.add(new Label("I can write a message !"));

			callback.onMappingOK(p,false);
		}
		else{
			callback.onError("All the lanes and all the start events should have been mapped.");
		}
		
	}

	
	public void onWindowInit(String userId) {}

	
	
	private class FakeMappingInfo implements MappingInformation{
		
		private String s;

		public FakeMappingInfo(String s) {
			this.setS(s);
		}
		
		protected FakeMappingInfo(){}

		public void setS(String s) {
			this.s = s;
		}

		public String getS() {
			return s;
		}
		
	}
	
}
