/**
 * bpel-export-client - BPEL Export integration test - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.presentation.gwt.bpel.client;

import java.io.Serializable;

import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.repository.FileRepositoryDescription;
import com.ebmwebsourcing.petalsbpm.mapping.client.ui.upload.SearchForm;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.service.to.SearchFormData;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.MultiFieldPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.ColumnLayoutData;

public class FakeRepositoryDescription extends FileRepositoryDescription{

//	List<SearchCriteria> lc = new ArrayList<SearchCriteria>();
//	lc.add(FakeSearchCriteria.CRITERIA1);
//	lc.add(FakeSearchCriteria.CRITERIA2);
//	lc.add(PetalsMasterSearchCriteria.NAME);
//
//	FileRepositoryDescription desc = new FileRepositoryDescription("file", "Fake Governance Utility", 
//			"com.ebmwebsourcing.petalsbpm.server.bpel.FakeWSDLRepositoryInquiryService",
//			lc, "http://www.fake.com");
	
	public FakeRepositoryDescription(){
		super("file","Fake Governance Utility",
				"com.ebmwebsourcing.petalsbpm.server.bpel.FakeWSDLRepositoryInquiryService",
				"http://www.petalslink.com/");
	}
	
	
	public SearchForm getSearchForm(){
		return new FakeSearchForm();
	}
	
	
	private class FakeSearchForm extends SearchForm{
		
		private TextField keywords;
		
		public FakeSearchForm(){
			super();
			setBorder(false);
			
			FormPanel formPanel = new FormPanel();
	        formPanel.setLabelWidth(100);  
	        formPanel.setBorder(false);
	        
	        keywords = new TextField("Search Keywords", "keywords", 250);  
	        keywords.setBlankText("This field is required.");
	        keywords.setAllowBlank(false);  
	        formPanel.add(keywords);
	        
	        MultiFieldPanel mfp = null;
	        boolean first = true;
	        
	        for(FakeSearchCriteria sc : FakeSearchCriteria.values()){
	        	Checkbox r = new Checkbox(sc.getDisplay());
	        	if(first){
	        		 r.setLabel("Search by:");
	        	     r.setChecked(true);
	        	     first = false;
	        	}
	        	if(mfp==null){
	        		MultiFieldPanel p = new MultiFieldPanel();
	        		p.setBorder(false);
	        		p.addToRow(r, 250);
	        		formPanel.add(p);
	        		mfp = p;
	        	}
	        	else{
	        		r.setHideLabel(true);
	        		mfp.addToRow(r,new ColumnLayoutData(1));
	        		mfp = null;
	        	}
	        }
	        
	        this.add(formPanel);
		}

		
		
		@Override
		public SearchFormData getInformation() {
			return null;
    	}
		
		

		@Override
		public String isInformationReady(){
			boolean textOK = keywords.getText()!=null && !keywords.getText().isEmpty();
			
			String msg = null;
			if(!textOK){
				msg = "Please enter a search phrase.";
			}
			
			return msg;
		}
		
	}
	
	
	public enum FakeSearchCriteria implements Serializable{
		CRITERIA1("Criteria1"),
		CRITERIA2("Criteria2");

		private String display;
		
		private FakeSearchCriteria(String d){
			this.display = d;
		}
		
		public String getDisplay() {
			return display;
		}
		
		public static FakeSearchCriteria fromValue(String v) {
	        for(FakeSearchCriteria sc : values()){
	        	if(sc.display.equals(v)){
	        		return sc;
	        	}
	        }
	        return null;
	    }
	}
	
}
