/**
 * definitions-editor - BPMN Definitions Editor Integration Test - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.integration;

import com.ebmwebsourcing.geasyschema.domain.mock.SchemaMockDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.PrivateProcessMockDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.SignalBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.OperationBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Configuration;
import com.ebmwebsourcing.petalsbpm.definitionseditor.DefinitionsController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.DefinitionsEditor;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.DefinitionsAvailableImport;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.RootPanel;

public class Application implements EntryPoint{

	@Override
	public void onModuleLoad() {
		
		
		
		XSDImportBean xsdImportBean1 = new XSDImportBean(new NamespaceDeclaration("ns1", "http://ns1"),SchemaMockDB.getSchema1());
		xsdImportBean1.setLocation("loc1");
		//xsdImportBean1.setNamespace("ns1");
		
		XSDImportBean xsdImportBean2 = new XSDImportBean(new NamespaceDeclaration("ns2", "http://ns2"),SchemaMockDB.getSchema1());
		xsdImportBean2.setLocation("loc2");
		//xsdImportBean2.setNamespace("ns2");
		
		
		DefinitionsAvailableImport.getInstance().addImport(xsdImportBean1);
		DefinitionsAvailableImport.getInstance().addImport(xsdImportBean2);		
		
		Configuration conf = new Configuration();
		final DefinitionsEditor defEditor = new DefinitionsEditor(conf);
		
		final DefinitionsBean defs1 = PrivateProcessMockDB.getProcess1();
		
		InterfaceBean it1 = new InterfaceBean(DOM.createUniqueId());
		it1.setName("interface1");
		
		MessageBean msg1 = new MessageBean(DOM.createUniqueId());
		msg1.setName("Message 1");
		msg1.setItemDefinition(new ItemDefinitionBean(DOM.createUniqueId()));
		
		
		OperationBean op1 = new OperationBean(DOM.createUniqueId());
		op1.setName("operation1");
		op1.setMessageIn(msg1);
		op1.setMessageOut(msg1);
		
		
		it1.addOperation(op1);
		
		defs1.addInterface(it1);
		
		defs1.addMessage(msg1);
		
		//add signal
		SignalBean sigBean = new SignalBean(DOM.createUniqueId());
		sigBean.setName("signal1");
		sigBean.setStructureRef(new ItemDefinitionBean(DOM.createUniqueId()));
		
		defs1.addSignal(sigBean);
		
		
		
		final DefinitionsController dc = new DefinitionsController(defEditor,defs1);
		
		
		Button loadBtn = new Button("Load definition");
		
		loadBtn.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				dc.load(defs1);
				
			}
		});
		

		Button addMsgButton = new Button("Add message");
		addMsgButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				MessageBean msg1 = new MessageBean(DOM.createUniqueId());
				msg1.setName(DOM.createUniqueId());
				defs1.addMessage(msg1);
				
			}
		});
		
		Button removeAllMessage = new Button("Remove All messages");
		removeAllMessage.addClickHandler(new  ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				defEditor.getMessagePanel().clearRecords();
				
			}
		});
		
		RootPanel.get().add(defEditor);
		
		RootPanel.get().add(loadBtn);
		RootPanel.get().add(addMsgButton);
		RootPanel.get().add(removeAllMessage);
	}

}
