/**
 * nfr-domain - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.business.domain.nfr.to;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IEnvVariablesBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IVariableBean;

/**
 * @author Sarah Zribi- Petals Link
 */

public class EnvVariablesBean implements IEnvVariablesBean {

	private static final long serialVersionUID = 1412478317772250743L;
	private List<IVariableBean> variable = new ArrayList<IVariableBean>();

	public EnvVariablesBean() {
		super();
	}

	@Override
	public void addVariable(IVariableBean var) {
		variable.add(var);
	}

	@Override
	public List<IVariableBean> getVariables() {
		return variable;
	}

	@Override
	public void removeVariable(IVariableBean responsetime) {
		variable.remove(responsetime);
	}

}
