/**
 * nfr-domain - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.business.domain.nfr.to;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IAccessabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IAvailabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMeasureFactorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IResponseTimeBean;
/**
 * @author Sarah Zribi- Petals Link
 */

public class MeasureFactorBean implements IMeasureFactorBean{


	private static final long serialVersionUID = -3185015920876282901L;
	private List<IResponseTimeBean> responseTime= new ArrayList<IResponseTimeBean>();
	private List<IAvailabilityBean> availabilityList= new ArrayList<IAvailabilityBean>();
	private List<IAccessabilityBean> accessabilityList= new ArrayList<IAccessabilityBean>();

	public MeasureFactorBean (){
		super();
	}

	@Override
	public void addResponseTime(IResponseTimeBean responsetime) {
		responseTime.add(responsetime);
	}
	@Override
	public List<IResponseTimeBean> getResponseTimes() {
		return responseTime;
	}
	@Override
	public void removeResponseTime(IResponseTimeBean responsetime) {
		responseTime.remove(responsetime);
	}


	@Override
	public void addAvailability(IAvailabilityBean availability) {
		this.availabilityList.add(availability);
	}
	@Override
	public List<IAvailabilityBean> getAvailabilities() {
		return availabilityList;
	}
	@Override
	public void removeAvailability(IAvailabilityBean availability) {
		this.availabilityList.remove(availability);
	}


	@Override
	public void addAccessability(IAccessabilityBean accessability) {
		this.accessabilityList.add(accessability);
	}
	@Override
	public List<IAccessabilityBean> getAccessabilities() {
		return accessabilityList;
	}
	@Override
	public void removeAccessability(IAccessabilityBean accessability) {
		this.accessabilityList.remove(accessability);
	}
}
