/**
 * nfr-domain - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.business.domain.nfr.to;

import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMetricValueBean;

/**
 * @author Sarah Zribi - Petals Link
 */

public class MetricValueBean implements IMetricValueBean{

	private static final long serialVersionUID = 8198789076358614230L;
	private int intValue;
	private Float floatValue;
	private String range;
	private String type;
	private String unit;
	private String description;

	public MetricValueBean (){
		super();
	}
	
	public MetricValueBean (float fval, String typ, String uni){
		super();
		this.setFloatValue(fval);
		this.setType(typ);
		this.setUnit(uni);
	}
	
	public MetricValueBean(String typ){
		super();
		this.setType(typ);
	}
	

	
	@Override
	public int getIntValue() {
		return intValue;
	}

	@Override
	public void setIntValue(int intvalue) {
		this.intValue = intvalue;
	}

	@Override
	public Float getFloatValue() {
		return floatValue;
	}

	@Override
	public void setFloatValue(Float floatvalue) {
		this.floatValue= floatvalue;
	}

	@Override
	public String getRange() {
		return range;
	}

	@Override
	public void setRange(String range) {
		this.range= range;
	}

	@Override
	public String getType() {
		return type;
	}

	@Override
	public void setType(String type) {
		this.type=type;
	}

	@Override
	public String getUnit() {
		return unit;
	}

	@Override
	public void setUnit(String unit) {
		this.unit= unit;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String description) {
		this.description= description;
	}
}
