/**
 * nfr-domain - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.business.domain.nfr.to;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IEnvVariablesBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMeasureDirectionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMetricValueBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IWithMetricValueBean;

/**
 * @author Sarah Zribi - Petals Link
 */

public class WithMetricValueBean implements IWithMetricValueBean{


	/**
	 * 
	 */
	private static final long serialVersionUID = 6676151177661091192L;
	private IMeasureDirectionBean measureDir;
	private IEnvVariablesBean envVar;
	private List<IMetricValueBean> metricValue = new ArrayList<IMetricValueBean>();

	public WithMetricValueBean(){
		super();
	}

	@Override
	public IMeasureDirectionBean getMeasureDirection() {
		return measureDir;
	}

	@Override
	public void setMeasureDirection(IMeasureDirectionBean measuredirection) {
		this.measureDir = measuredirection;		
	}

	@Override
	public IEnvVariablesBean getEnvVariables() {
		return envVar;
	}

	@Override
	public void setEnvVariables(IEnvVariablesBean envvariables) {
		this.envVar = envvariables;
	}

	@Override
	public void addMetricValue(IMetricValueBean metricvalue) {
		metricValue.add(metricvalue);
	}

	@Override
	public List<IMetricValueBean> getMetricValues() {
		return metricValue;
	}

	@Override
	public void removeMetricValue(IMetricValueBean metricvalue) {
		metricValue.remove(metricvalue);
	}

}
