/**
 * nfr-service - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.service.extension;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.AccessabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.AvailabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.EnvVariablesBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.MeasureFactorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.MetricValueBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.ResponseTimeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.VariableBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.activity.PerformanceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IAccessabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IAvailabilityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMeasureFactorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMetricValueBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IResponseTimeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IVariableBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IWithMetricValueBean;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBinder;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.anonymoustype.MeasureFactor;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.anonymoustype.MetricValue;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.Accessability;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.Availability;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.EnvVariables;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.Performance;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.ResponseTime;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.Variable;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.type.TMetricType;
import com.ebmwebsourcing.wsstar.wspolicy15.api.anonymoustype.Policy;

/**
 * @author Sarah Zribi- Petals Link
 */

public class NfrExtensionBinder extends ExtensionBinder{

	private XmlContext context;

	///////////////////
	//Client to server
	///////////////////

	private <T extends TMetricType> T generateContext(IWithMetricValueBean metricValueBean, Class<T> finalClass) {

		T context = getXmlContext().getXmlObjectFactory().create(finalClass);
		//EnvVariables
		EnvVariables env= getXmlContext().getXmlObjectFactory().create(EnvVariables.class);
		//Variable
		if (metricValueBean.getEnvVariables() != null && metricValueBean.getEnvVariables().getVariables()!= null) {
			for (IVariableBean variable : metricValueBean.getEnvVariables().getVariables()){
				Variable var= getXmlContext().getXmlObjectFactory().create(Variable.class);
				var.setVarName(variable.getVarName());
				var.setVarValue(variable.getVarValue());
				env.addVariable(var);
			}
		}
		//Metric Value
		if (metricValueBean.getMetricValues()!= null){
			for (IMetricValueBean mvbean : metricValueBean.getMetricValues()){
				MetricValue mv = getXmlContext().getXmlObjectFactory().create(MetricValue.class);
				Float value = mvbean.getFloatValue();
				if (value != null) {
					if (!(mvbean instanceof IResponseTimeBean)) {
						//Percentage
						value /= 100;
					}
					mv.setFloatValue(value);
				}
				mv.setType(mvbean.getType());
				if (mvbean instanceof IResponseTimeBean) {
					mv.setUnit(mvbean.getUnit());
				}
				if (mvbean.getRange() != null) {
					mv.setRange(mvbean.getRange());
				}
				mv.setDescription(mvbean.getDescription());
				context.addMetricValue(mv);
			}
		}
		context.setEnvVariables(env);

		return context;
	}


	/**
	 * @param ext The bean representing the xml extension of a BPMN object
	 * @return The XmlObject representing the xml extension of a BPMN object
	 * @throws IllegalArgumentException if this binder was not designed to handle this kind of extensions
	 */
	@Override
	protected XmlObject clientToServer(ObjectExtension ext)
	throws IllegalArgumentException {
		Policy policy = null;

		if ( ext instanceof PerformanceBean){
			policy = getXmlContext().getXmlObjectFactory().create(Policy.class);
			Performance perf = getXmlContext().getXmlObjectFactory().create(Performance.class);
			policy.addAnyXmlObject(perf);

			//MeasureFactor
			List<IMeasureFactorBean> extmeasurefact = ((PerformanceBean) ext).getMeasureFactor();
			if(( (PerformanceBean) ext).getMeasureFactor() != null) {
				for (IMeasureFactorBean measure :  extmeasurefact) {
					MeasureFactor measurefact = getXmlContext().getXmlObjectFactory().create(MeasureFactor.class);
					for (IResponseTimeBean responseTimeBean : measure.getResponseTimes()) {
						ResponseTime response = generateContext(responseTimeBean, ResponseTime.class);
						measurefact.addResponseTime(response);
					}
					for (IAvailabilityBean availabilityBean : measure.getAvailabilities()) {
						Availability av = generateContext(availabilityBean, Availability.class);
						measurefact.addAvailability(av);
					}
					for (IAccessabilityBean accessabilityBean : measure.getAccessabilities()) {
						Accessability ac = generateContext(accessabilityBean, Accessability.class);
						measurefact.addAccessability(ac);
					}
					perf.addMeasureFactor(measurefact);
				}
			}
		}

		else{
			throw new IllegalArgumentException (ext.getClass()+" is not supported yet as Non Functional Requirements BPMN extension");
		}
		return policy;
	}

	@Override
	protected List<Class<? extends ObjectExtension>> getSupportedBeans() {
		List<Class<? extends ObjectExtension>> result = new ArrayList<Class<? extends ObjectExtension>>();
		result.add(PerformanceBean.class);
		return result;
	}

	///////////////////
	//Server to client
	///////////////////

	private <T extends IWithMetricValueBean> T generateBean(TMetricType metricValue, Class<T> finalClass) {

		T bean = null;
		try {
			bean = finalClass.newInstance();
			//EnvVariables
			EnvVariablesBean env= new EnvVariablesBean();
			//Variable
			if (metricValue.hasEnvVariables() && metricValue.getEnvVariables().hasVariable()) {
				for (Variable variable : metricValue.getEnvVariables().getVariables()){
					VariableBean varb = new VariableBean(variable.getVarName(), variable.getVarValue());
					env.addVariable(varb);
				}
			}
			//Metric Value
			if (metricValue.hasMetricValue()){
				for (MetricValue mv : metricValue.getMetricValues()){
					MetricValueBean val = new MetricValueBean(mv.getFloatValue(), mv.getType(), mv.getUnit());
					bean.addMetricValue(val);
				}
			}
			bean.setEnvVariables(env);
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return bean;
	}


	/**
	 * @param ext The XmlObject representing the xml extension of a BPMN object
	 * @return The bean representing the xml extension of a BPMN object
	 * @throws IllegalArgumentException if this binder was not designed to handle this kind of extensions
	 */

	@Override
	protected ObjectExtension serverToClient(XmlObject ext)
	throws IllegalArgumentException {

		PerformanceBean perf =null;

		if(ext instanceof Policy){
			if ( !((Policy) ext).hasAnyXmlObject(Performance.QNAME)){
				throw new IllegalArgumentException ("The policy does not contain a Performance");
			}
			else if(((Policy) ext).getAnyXmlObjects(Performance.QNAME).length>1){
				throw new IllegalArgumentException ("Policy can not have more than one Performance");
			}

			perf = new PerformanceBean();
			//MeasureFactor
			Performance per = (Performance) ((Policy) ext).getAnyXmlObjects(Performance.QNAME)[0];
			if (per.hasMeasureFactor()) {
				MeasureFactor[] extmeasurefact = per.getMeasureFactor();
				for (MeasureFactor measure :  extmeasurefact) {
					MeasureFactorBean measurefact = new MeasureFactorBean();
					//ResponseTime
					for (ResponseTime resptime : measure.getResponseTimes()) {
						ResponseTimeBean response = generateBean(resptime, ResponseTimeBean.class);
						measurefact.addResponseTime(response);
					}
					//Availability
					for (Availability availability : measure.getAvailabilities()){					
						AvailabilityBean av= generateBean(availability, AvailabilityBean.class);
						measurefact.addAvailability(av);
					}
					//Accessability
					for (Accessability accessability : measure.getAccessabilities()){					
						AccessabilityBean ac= generateBean(accessability, AccessabilityBean.class);
						measurefact.addAccessability(ac);
					}
					perf.addMeasureFactor(measurefact);
				}
			}
		}
		else{
			throw new IllegalArgumentException (ext.getClass()+" is not supported yet as Non Functional Requirements BPMN extension");
		}
		return perf;
	}

	@Override
	protected List<Class<? extends XmlObject>> getSupportedXmlObjects() {
		List<Class<? extends XmlObject>> result = new ArrayList<Class<? extends XmlObject>>();
		result.add(Policy.class);
		return result;
	}

	private XmlContext getXmlContext(){
		if(context==null){
			context = new XmlContextFactory().newContext();
		}
		return context;
	}
}
