/**
 * petalsbpm-client-demo - Petals BPM Client DEMO - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.bugreport.ui;

import com.ebmwebsourcing.geasytools.webeditor.ui.component.menu.GWTExtMenuComponentButton;
import com.ebmwebsourcing.petalsbpm.client.bugreport.model.BugReport;
import com.ebmwebsourcing.petalsbpm.client.bugreport.rpc.IBugReportService;
import com.ebmwebsourcing.petalsbpm.client.bugreport.rpc.IBugReportServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.RepeatingCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.gwtext.client.core.Function;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Tool;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextArea;
import com.gwtext.client.widgets.form.TextField;

public class BugReportWindow {

	private Window window;
	public static final int WINDOW_WIDTH = 500;
	public static final int WINDOW_HEIGHT = 500;

	private IBugReportServiceAsync service = GWT
			.create(IBugReportService.class);

	public BugReportWindow() {
		window = new Window("Help us to improve Petals BPM !", WINDOW_WIDTH,
				WINDOW_HEIGHT);
		window.setIconCls("bug");
		window.setClosable(false);
		window.setAnimCollapse(true);
		window.addTool(new Tool(Tool.MINIMIZE, new Function() {

			@Override
			public void execute() {

				window.collapse(true);

			}
		}));

		window.addTool(new Tool(Tool.MAXIMIZE, new Function() {

			@Override
			public void execute() {

				window.expand(true);

			}
		}));

		window.setCloseAction(Window.HIDE);

		window.add(getPanel());
	}

	private Panel getPanel() {

		FormPanel panel = new FormPanel();

		Label l = new Label(
				"You have encountered a bug ? Help us to improve Petals BPM !");

		panel.add(l);
		l
				.getElement()
				.setAttribute(
						"style",
						"font-size:14px;font-weight:bold;margin-top:10px;margin-bottom:10px;margin-left:10px;");
		FieldSet fs = new FieldSet();

		final TextField subjectTxt = new TextField("Subject");
		subjectTxt.setAllowBlank(false);
		
		final TextField emailTxt = new TextField("Email");

		final TextArea txtArea = new TextArea("Bug description");
		txtArea.setAllowBlank(false);

		txtArea.setSize(300, 300);

		fs.add(subjectTxt);
		fs.add(txtArea);

		fs.add(emailTxt);

		panel.add(fs);

		Button btn = new Button("Send");
		btn.addListener(new ButtonListenerAdapter() {

			public void onClick(Button button,
					com.gwtext.client.core.EventObject e) {

				if (subjectTxt.getText().isEmpty() == false
						&& txtArea.getText().isEmpty() == false) {

					BugReport br = new BugReport();

					StringBuilder body = new StringBuilder();
					body.append("Bug description:\n");
					body.append("====================\n");
					body.append(txtArea.getText() + "\n\n");
					body.append("Platform:\n");
					body.append("=========\n");
					body.append(com.google.gwt.user.client.Window.Navigator
							.getPlatform()
							+ "\n\n");
					body.append("User Agent:\n");
					body.append("===========\n");
					body.append(com.google.gwt.user.client.Window.Navigator
							.getUserAgent());

					br.setSubject(subjectTxt.getText());
					br.setBody(body.toString());
					br.setSenderMail(emailTxt.getText());

					service.send(br, new AsyncCallback<Void>() {

						@Override
						public void onSuccess(Void result) {

							txtArea.setValue("");
							subjectTxt.setValue("");
							emailTxt.setValue("");

							MessageBoxConfig c = new MessageBoxConfig();
							c.setTitle("Bug report successfully sent !");
							c.setModal(true);
							c
									.setMsg("Thanks for your contribution, your report has been successfully sent !");
							c.setIconCls(MessageBox.INFO);

							MessageBox.show(c);

							window.collapse();
						}

						@Override
						public void onFailure(Throwable caught) {

							MessageBoxConfig c = new MessageBoxConfig();
							c.setTitle("An error occurred");
							c.setModal(true);
							c
									.setMsg("Sorry, an error occured while trying to send your report... try again later please.");
							c.setIconCls(MessageBox.ERROR);

							MessageBox.show(c);
							
							
						}
					});

				}

			};

		});

		panel.addButton(btn);

		return panel;
	}

	public void setPosition(int left, int top) {
		window.setPosition(left, top);
	}

	public void show() {
		window.show();

		Scheduler.get().scheduleFixedDelay(new RepeatingCommand() {

			@Override
			public boolean execute() {

				window.collapse();

				return false;
			}
		}, 3000);

	}

	public void hide() {
		window.hide();
	}

}
