/**
 * petalsbpm-client-demo - Petals BPM Client DEMO - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.core;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorView;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IPlugin;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.EditorController;
import com.ebmwebsourcing.geasytools.webeditor.ui.component.menu.GWTExtMenuComponentButton;
import com.ebmwebsourcing.geasytools.webeditor.ui.core.EditorView;
import com.ebmwebsourcing.petalsbpm.client.bugreport.ui.BugReportWindow;
import com.ebmwebsourcing.petalsbpm.client.component.bpmn.WelcomeComponent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.choreography.BPMNChoreographyPlugin;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.collaboration.DescriptiveBPMNCollaborationPlugin;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.process.DescriptiveBPMNPrivateProcessPlugin;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.collaboration.ExecutableBPMNCollaborationPlugin;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.process.ExecutableBPMNPrivateProcessPlugin;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;
import com.gwtext.client.widgets.MessageBox.PromptCallback;

public class BPMNEditorClient implements EntryPoint {
	
	private GWTExtMenuComponentButton bpelDeployBtn;
	private BugReportWindow bugWindow;

	
    public void onModuleLoad() {
    	final EditorView bpmneditorView = new EditorView();
        final Panel panel = (Panel) bpmneditorView.getMainWidget();

        new Viewport(panel);

        HashSet<IPlugin> plugins = new HashSet<IPlugin>();
        plugins.add(new DescriptiveBPMNPrivateProcessPlugin());
        plugins.add(new ExecutableBPMNPrivateProcessPlugin());
        plugins.add(new DescriptiveBPMNCollaborationPlugin());
        plugins.add(new ExecutableBPMNCollaborationPlugin());
        plugins.add(new BPMNChoreographyPlugin());
        
        MessageBoxConfig config = new MessageBoxConfig();
        config.setMsg("This version of PetalsBPM is for demo purpose only and is frequently updated.Please, be aware that any saved data will be deleted.");
        config.setIconCls(MessageBox.INFO);
        config.setCallback(new PromptCallback() {
			
			@Override
			public void execute(String btnID, String text) {
				
				bugWindow = new  BugReportWindow();
				bugWindow.show();
				bugWindow.setPosition(Window.getClientWidth()-BugReportWindow.WINDOW_WIDTH, 0);
			}
		});
        
        
        MessageBox.show(config);
        
        try {
        	addButtons(bpmneditorView);
        	
            EditorController ec = new EditorController(bpmneditorView, plugins);

            bpmneditorView.getLayout().getMainContentPanelPlaceHolder().addComponent(
                    new WelcomeComponent(ec.getEventBus()));

            addButtonListeners(ec);
            
            
        } catch (Throwable e) {
            Window.alert(e.getMessage());
        }
    }
    
    private void addButtons(IEditorView bpmneditorView) {
		bpelDeployBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL() + "/images/bus.png"));
		bpelDeployBtn.setTitle("Deploy process");
		bpmneditorView.getToolbarComponent().addMenuButton(bpelDeployBtn);
	}
	
	private void addButtonListeners(EditorController ec) {
		bpelDeployBtn.setClickHandler(new IMenuItemClickHandler() {
			@Override
			public void onClick() {
				MessageBoxConfig config = new MessageBoxConfig();
		        config.setMsg("The deployment feature is not available for the demo of PetalsBPM. If " +
		        		"you want to access this functionnality please go to our " +
		        		"<a href=\"http://research.petalslink.org/display/petalsbpm/Petals+BPM+-+Open+source+BPMN+2.0+modeler\"" +
		        		"target=\"_blank\">website</a>.");
		        config.setIconCls(MessageBox.INFO);
		        MessageBox.show(config);
			}
		});
	}

}
