/**
 * petalsbpm-client-demo - Petals BPM Client DEMO - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.server.bugreport.service;

import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import com.ebmwebsourcing.petalsbpm.client.bugreport.model.BugReport;
import com.ebmwebsourcing.petalsbpm.client.bugreport.rpc.IBugReportService;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class BugReportServiceImpl extends RemoteServiceServlet implements IBugReportService{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public void send(BugReport report) {
	
		
	      String to = "graham.crosmarie@petalslink.com";
	      String from = "bugreport@bpmneditor.com";

	      if (report.getSenderMail().isEmpty()==false){
	    	  from = report.getSenderMail();
	      }
	      
	   
	      String host = "localhost";

	      Properties properties = System.getProperties();

	      properties.setProperty("mail.smtp.host", host);

	      Session session = Session.getDefaultInstance(properties);

	      try{
	   
	         MimeMessage message = new MimeMessage(session);

	         message.setFrom(new InternetAddress(from));
	         message.addRecipient(Message.RecipientType.TO,
	                                  new InternetAddress(to));
	         message.setSubject(report.getSubject());
	         message.setText(report.getBody());

	         Transport.send(message);
	         
	         System.out.println("Message successfully sent....");
	         
	      }catch (MessagingException e) {

	    	  e.printStackTrace();
	    	  
		}
		
		
		
	}

}
