/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.ICallableElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ICallActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.WSDLImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;

public class XMLToClientTest {
    @Test
    public void testOMG() {
        XmlContext context = new XmlContextFactory().newContext();
        String[] files = new String[]{"CallActivity.bpmn", "EmailVoting2.bpmn", "HardwareRetailerv2.bpmn", "IncidentManagement-collchor.bpmn", "IncidentManagement(ProcessEngineExecutable).bpmn", "IncidentManagement(WholeCollab).bpmn", "NobelPrizeProcess.bpmn", "OrderProcessforPizzaV4.bpmn", "ProcurementProcesseswithErrorHandling.bpmn", "TavelBooking.bpmn"};
        int cpt = 0;
        for (String file : files) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("omg/" + file);
                Definitions defs = (Definitions)context.createReader().readDocument(is, Definitions.class);
                context.createValidator().failFastValidate((XmlObject)defs);
                DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
                Definitions d = ClientToServer.adapt((DefinitionsBean)defsBean);
                Assert.assertEquals((int)defs.getCollaborations().length, (int)d.getCollaborations().length);
                Assert.assertEquals((int)defs.getImports().length, (int)d.getImports().length);
                Assert.assertEquals((int)defs.getInterfaces().length, (int)d.getInterfaces().length);
                Assert.assertEquals((int)defs.getItemDefinitions().length, (int)d.getItemDefinitions().length);
                Assert.assertEquals((int)defs.getMessages().length, (int)d.getMessages().length);
                Assert.assertEquals((int)defs.getProcesses().length, (int)d.getProcesses().length);
                Assert.assertEquals((int)defs.getChoreographies().length, (int)d.getChoreographies().length);
                ++cpt;
                System.out.println(file + " successed.");
            }
            catch (IllegalArgumentException e) {
                System.out.println(file + " was skipped.\t" + e.getMessage());
            }
            catch (Exception t) {
                System.out.println(file + " failed.");
                t.printStackTrace();
                Assert.fail();
            }
        }
        System.out.println(cpt + "/" + files.length + " files transformation succeeded.");
    }

    @Test
    public void testBPMNImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("CallingDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)1, (int)defsBean.getImports().size());
        IImportBean impt = (IImportBean)defsBean.getImports().get(0);
        Assert.assertEquals((String)"http://easybpmn.ebmwebsourcing.com/imported", (String)impt.getNamespace());
        Assert.assertTrue((boolean)(impt instanceof BPMN20ImportBean));
        Assert.assertNotNull((Object)((BPMN20ImportBean)impt).getBPMN20Definitions());
        INamespaceDeclaration nsd = impt.getNSDeclaration();
        Assert.assertEquals((String)"http://easybpmn.ebmwebsourcing.com/imported", (String)nsd.getURI());
        Assert.assertEquals((String)"imported", (String)nsd.getPrefix());
        Assert.assertNotNull((Object)defsBean.getProcesses());
        Assert.assertEquals((int)1, (int)defsBean.getProcesses().size());
        IProcessBean proc = (IProcessBean)defsBean.getProcesses().get(0);
        Assert.assertNotNull((Object)proc);
        Assert.assertNull((Object)proc.getNSDeclaration());
        Assert.assertEquals((String)"process1ID", (String)proc.getId());
        Assert.assertEquals((String)"process1Name", (String)proc.getName());
        Assert.assertNotNull((Object)proc.getFlowNodes());
        Assert.assertEquals((int)1, (int)proc.getFlowNodes().size());
        IFlowElementBean ca = (IFlowElementBean)proc.getFlowNodes().get(0);
        Assert.assertEquals((String)"callActiId", (String)ca.getId());
        Assert.assertTrue((boolean)(ca instanceof ICallActivityBean));
        ICallableElementBean ceb = ((ICallActivityBean)ca).getCalledElement();
        Assert.assertNotNull((Object)ceb);
        Assert.assertEquals((String)"process2ID", (String)ceb.getId());
        Assert.assertNotNull((Object)ceb.getNSDeclaration());
        INamespaceDeclaration nsd2 = ceb.getNSDeclaration();
        Assert.assertEquals((String)"http://easybpmn.ebmwebsourcing.com/imported", (String)nsd2.getURI());
        Assert.assertEquals((String)"imported", (String)nsd2.getPrefix());
    }

    @Test
    public void testXSDImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("Definitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)2, (int)defsBean.getImports().size());
        IImportBean i = (IImportBean)defsBean.getImports().get(0);
        if (!(i instanceof XSDImportBean)) {
            i = (IImportBean)defsBean.getImports().get(1);
        }
        XSDImportBean si = (XSDImportBean)i;
        Assert.assertEquals((int)2, (int)si.getSchema().getElements().size());
        Assert.assertEquals((int)0, (int)si.getSchema().getImports().size());
        ClientToServer.adapt((DefinitionsBean)defsBean);
    }

    @Test
    public void testWSDLImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("EmptyDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)1, (int)defsBean.getImports().size());
        IImportBean i = (IImportBean)defsBean.getImports().get(0);
        Assert.assertTrue((boolean)(i instanceof WSDLImportBean));
        WSDLImportBean wi = (WSDLImportBean)i;
        String[] itfNames = new String[]{"DB", "FlightBook"};
        String[] opNames = new String[]{"bookFlight", "DBQuerying"};
        String[] msgNames = new String[]{"bookFlightResponse", "bookFlightRequest", "DBQueryCall", "DBQueryResponse"};
        Assert.assertNotNull((Object)wi.getInterfaces());
        Assert.assertEquals((int)2, (int)wi.getInterfaces().size());
        for (String itfName : itfNames) {
            IInterfaceBean itf = wi.getInterfaceByName(itfName);
            Assert.assertNotNull((Object)itf);
            Assert.assertEquals((String)itfName, (String)itf.getName());
        }
        Assert.assertNotNull((Object)wi.getOperations());
        Assert.assertEquals((int)2, (int)wi.getOperations().size());
        for (String opName : opNames) {
            IOperationBean op = wi.getOperationByName(opName);
            Assert.assertNotNull((Object)op);
            Assert.assertEquals((String)opName, (String)op.getName());
        }
        Assert.assertNotNull((Object)wi.getMessages());
        Assert.assertEquals((int)4, (int)wi.getMessages().size());
        for (String msgName : msgNames) {
            IMessageBean msg = wi.getMessageByName(msgName);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((String)msgName, (String)msg.getName());
        }
        ClientToServer.adapt((DefinitionsBean)defsBean);
    }
}

