/**
 * service - BPMN Editor service - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.service.extension;

import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;

public abstract class ExtensionBinder {

	///////////////////
	//Client to server
	///////////////////
	/**
	 * @param ext The bean representing the xml extension of a BPMN object
	 * @return The XmlObject representing the xml extension of a BPMN object
	 * @throws IllegalArgumentException if this binder was not designed to handle this kind of extensions
	 */
	public abstract XmlObject clientToServer(ObjectExtension ext) throws IllegalArgumentException;
	
	public abstract List<Class<? extends ObjectExtension>> getSupportedBeans();
	
	public boolean supportsObjectExtensionBean(Class<? extends ObjectExtension> c){
		for(Class<? extends ObjectExtension> clazz : getSupportedBeans()){
			if(clazz.isAssignableFrom(c)){
				return true;
			}
		}
		return false;
	}
	
	///////////////////
	//Server to client
	///////////////////
	/**
	 * @param ext The XmlObject representing the xml extension of a BPMN object
	 * @return The bean representing the xml extension of a BPMN object
	 * @throws IllegalArgumentException if this binder was not designed to handle this kind of extensions
	 */
	public abstract ObjectExtension serverToClient(XmlObject ext) throws IllegalArgumentException;
	
	public abstract List<Class<? extends XmlObject>> getSupportedXmlObjects();
	
	public boolean supportsXmlObject(Class<? extends XmlObject> c){
		for(Class<? extends XmlObject> clazz : getSupportedXmlObjects()){
			if(clazz.isAssignableFrom(c)){
				return true;
			}
		}
		return false;
	}
}
