/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server.launcher;

import com.ebmwebsourcing.seacloud.launcher.SeaCloudWithEtalisLauncher;
import com.ebmwebsourcing.seacloud.launcher.util.SystemExitHook;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.SeaCloudUI;
import com.ebmwebsourcing.seacloud.server.launcher.ConfigurationImpl;
import com.ebmwebsourcing.seacloud.server.launcher.SeaCloudUIWithEsperLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;

public class SeaCloudUIWithEtalisLauncher
extends SeaCloudWithEtalisLauncher {
    private SeaCloudUI serverUI;

    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new Exception("Can not start the SeaCloud server, remove lock file from SeaCloud root path or stop server");
        }
        this.locker.lock();
        ConfigurationImpl conf = new ConfigurationImpl();
        String host = conf.getHost();
        int port = conf.getPort();
        if (host == null || port <= 0) {
            throw new Exception("Wrong host or port parameters!!!");
        }
        String seaCloudServerAddress = "http://" + host + ":" + port + "/SeaCloudAdmin";
        ResourcesDescriptor descriptor = null;
        this.serverUI = new SeaCloudUI(seaCloudServerAddress, SeaCloud.CEP_MODE.ESPER, descriptor, false, this.useMock);
        this.serverUI.refreshAll();
        this.serverUI.setVisible(true);
        this.server = this.serverUI.getServer();
        System.out.println("SeaCloud with Esper started at: http://" + host + ":" + port + "/SeaCloudAdmin");
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook((Thread)this.systemExitHook);
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/seacloud-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : SeaCloudUIWithEsperLauncher.class.getClass().getResourceAsStream("/logger/seacloud-logging.properties");
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

