/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven;

import com.ebmwebsourcing.tools.maven.SvnSection;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.reactor.SuperProjectSorter;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public final class ProjectHelper {
    private static final Pattern svnBootstrapSectionPattern = Pattern.compile("svnroot/trunk/(product|research)/bootstrap/");
    private static final Pattern svnDevSectionPattern = Pattern.compile("svnroot/trunk/(product|research)/dev/([^/]*)/");

    private ProjectHelper() {
    }

    public static final boolean isAggregatorProject(MavenProject project) {
        return !project.getModules().isEmpty();
    }

    public static final String guessMavenProjectSvnSection(MavenProject mavenProject) {
        if (mavenProject.getScm() == null) {
            return "unknown";
        }
        if (mavenProject.getScm().getConnection() == null) {
            return "unknown";
        }
        String scmConnection = mavenProject.getScm().getConnection();
        Matcher matcher = svnBootstrapSectionPattern.matcher(scmConnection);
        if (matcher.find()) {
            return "bootstrap";
        }
        matcher = svnDevSectionPattern.matcher(scmConnection);
        if (matcher.find()) {
            String guessedSvnSection = matcher.group(2);
            return SvnSection.fromString(guessedSvnSection);
        }
        return "unknown";
    }

    public static final List<MavenProject> getSortedProjects(MavenSession session, MavenProject project) {
        LinkedList<MavenProject> sortedProjects = new LinkedList();
        try {
            SuperProjectSorter sps = new SuperProjectSorter(ProjectHelper.getProjects(session, project));
            sortedProjects = sps.getSortedProjects();
            return sortedProjects;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final void addProjectModules(MavenProjectBuilder mavenProjectBuilder, ProfileManager profileManager, MavenProject proj, List<MavenProject> moduleList, MavenSession session) {
        try {
            List projectModules = proj.getModules();
            for (String module : projectModules) {
                File moduleFile = new File(proj.getBasedir().getAbsolutePath() + "/" + module + "/pom.xml");
                MavenProject moduleProject = mavenProjectBuilder.build(moduleFile, session.getLocalRepository(), profileManager);
                ProjectHelper.addProjectModules(mavenProjectBuilder, profileManager, moduleProject, moduleList, session);
            }
            moduleList.add(proj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final List<MavenProject> getProjects(MavenSession session, MavenProject project) {
        try {
            MavenProjectBuilder mpb = (MavenProjectBuilder)session.lookup(MavenProjectBuilder.ROLE);
            DefaultProfileManager pm = new DefaultProfileManager(session.getContainer(), session.getSettings());
            LinkedList<MavenProject> allModules = new LinkedList<MavenProject>();
            ProjectHelper.addProjectModules(mpb, (ProfileManager)pm, project, allModules, session);
            return allModules;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final MavenProject findMavenProjectInReactor(MavenSession mavenSession, String groupId, String artifactId) {
        for (MavenProject project : mavenSession.getSortedProjects()) {
            if (!groupId.equals(project.getGroupId()) || !artifactId.equals(project.getArtifactId())) continue;
            return project;
        }
        return null;
    }

    public static final MavenProject findMavenProjectForDependency(MavenSession session, MavenProject parentProject, Dependency dependency) throws ExpressionEvaluationException, ComponentLookupException {
        ArtifactRepository localRepository = session.getLocalRepository();
        ArtifactFactory artifactFactory = (ArtifactFactory)session.lookup(ArtifactFactory.ROLE);
        Artifact pomArtifact = artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
        MavenProjectBuilder mpb = (MavenProjectBuilder)session.lookup(MavenProjectBuilder.ROLE);
        try {
            MavenProject dependencyMavenProject = mpb.buildFromRepository(pomArtifact, parentProject.getRemoteArtifactRepositories(), localRepository);
            return dependencyMavenProject;
        }
        catch (ProjectBuildingException e) {
            throw new RuntimeException("Cannot create dependency MavenProject.", e);
        }
    }

    public static final boolean isPetalsLinkProject(String groupId, String artifactId) {
        if ("petals-jaas".equals(artifactId)) {
            return false;
        }
        if (groupId.startsWith("com.ebmwebsourcing")) {
            return true;
        }
        if (groupId.startsWith("com.petalslink")) {
            return true;
        }
        if (groupId.startsWith("org.ow2.dragon")) {
            return true;
        }
        if (groupId.startsWith("org.ow2.easywsdl")) {
            return true;
        }
        return groupId.startsWith("org.ow2.petals");
    }
}

