/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.project.MavenProject;

public final class SvnUtil {
    private SvnUtil() {
    }

    public static final String grepScmConnectionFromSvnEntries(MavenProject project) throws Exception {
        File basedir = project.getBasedir();
        File svnDir = new File(basedir, ".svn");
        File svnEntriesFile = new File(svnDir, "entries");
        if (!svnEntriesFile.exists() || !svnEntriesFile.canRead()) {
            return null;
        }
        String svnPath = SvnUtil.grepSvnPathFromEntries(svnEntriesFile);
        if (svnPath == null) {
            return null;
        }
        return "scm:svn:" + svnPath;
    }

    private static final String grepSvnPathFromEntries(File svnEntriesFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(svnEntriesFile));
            String svnPath = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("https://") && !line.startsWith("svn://")) continue;
                svnPath = line;
                break;
            }
            return svnPath;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

