/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class ReleasedDependencyRequired
extends AbstractRule {
    private static final Set<Dependency> releasedDependenciesRequired = new HashSet<Dependency>();

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)o;
            this.checkReleasedVersion(dep);
        }
    }

    private static void initExcludedDependencies() {
    }

    private void checkReleasedVersion(Dependency currentDependency) throws EnforcerRuleException {
        for (Dependency d : releasedDependenciesRequired) {
            if (!currentDependency.getArtifactId().equals(d.getArtifactId()) || !currentDependency.getGroupId().equals(d.getGroupId()) || currentDependency.getVersion().equals(d.getVersion())) continue;
            throw new EnforcerRuleException(String.format("Project depends on %s with version %s but only released dependency with version %s is allowed.", currentDependency.getArtifactId(), currentDependency.getVersion(), d.getVersion()));
        }
    }

    static {
        ReleasedDependencyRequired.initExcludedDependencies();
    }
}

