/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.auth;

import com.ebmwebsourcing.webcommons.user.api.service.UserException;
import com.ebmwebsourcing.webcommons.user.api.to.RoleTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public class JDBCLoginModule
implements LoginModule {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CallbackHandler callbackHandler = null;
    private Subject subject = null;
    private boolean success = false;
    private boolean commited = false;
    private String jdbcURL;
    private String jdbcDriver;
    private String requestUser;
    private String requestRole;
    private String userDb;
    private String passDb;
    private UserTO user;
    private List<RoleTO> roles;

    @Override
    public boolean abort() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (this.success && !this.commited) {
            this.reset();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.user)) {
            this.subject.getPrincipals().add(this.user);
        }
        if (!this.subject.getPrincipals().contains(this.roles)) {
            this.subject.getPrincipals().addAll(this.roles);
        }
        this.commited = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.jdbcURL = (String)options.get("url");
        this.jdbcDriver = (String)options.get("driver");
        this.requestUser = (String)options.get("requestUser");
        this.requestRole = (String)options.get("requestRole");
        this.userDb = (String)options.get("userDb");
        this.passDb = (String)options.get("passDb");
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Erreur : pas de callback");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Name : "), new PasswordCallback("Password :", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String userName = ((NameCallback)callbacks[0]).getName();
            char[] ac = ((PasswordCallback)callbacks[1]).getPassword();
            char[] pass = new char[ac.length];
            System.arraycopy(ac, 0, pass, 0, ac.length);
            String password = new String(pass);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.success = this.rdbValidate(userName, password);
            callbacks[0] = null;
            callbacks[1] = null;
            if (!this.success) {
                throw new LoginException("Authentification incorrecte !");
            }
            System.out.println("Vous \u00eates maintenant connect\u00e9");
            return this.success;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean logout() throws LoginException {
        Iterator<Principal> it = this.subject.getPrincipals().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof UserTO)) continue;
            this.subject.getPrincipals().remove(it);
        }
        return true;
    }

    private boolean rdbValidate(String userName, String password) throws UserException {
        boolean passwordMatch = false;
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (ClassNotFoundException cnfex) {
            this.logger.info((Object)cnfex);
        }
        try {
            String queryUser = this.requestUser + "'" + userName + "'";
            Connection con = DriverManager.getConnection(this.jdbcURL, this.userDb, this.passDb);
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(queryUser);
            String dbPassword = null;
            String dbLogin = null;
            while (rs.next()) {
                dbPassword = rs.getString(2);
                dbLogin = rs.getString(1);
            }
            if (dbPassword == null) {
                this.logger.info((Object)"The user name or the password isn't correct");
            }
            String passwordTmp = this.passwordCrypting(password);
            passwordMatch = passwordTmp.equals(dbPassword);
            rs.close();
            this.user = new UserTO();
            this.user.setName(dbLogin);
            this.user.setPassword(dbPassword);
            String queryRoles = this.requestRole + "'" + dbLogin + "'";
            ResultSet rs2 = stmt.executeQuery(queryRoles);
            String roleName = null;
            this.roles = new ArrayList<RoleTO>();
            RoleTO role = new RoleTO();
            role.setName("ROLE_AUTH");
            this.roles.add(role);
            while (rs2.next()) {
                roleName = rs2.getString(1);
                role = new RoleTO();
                role.setName("ROLE_" + roleName);
                this.roles.add(role);
            }
            rs2.close();
            stmt.close();
            con.close();
        }
        catch (SQLException sqlex) {
            this.logger.info((Object)sqlex);
        }
        return passwordMatch;
    }

    private void reset() {
        this.success = false;
        this.callbackHandler = null;
        this.subject = null;
        this.commited = false;
    }

    private String passwordCrypting(String password) {
        byte[] uniqueKey = password.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No MD5 support in this VM.");
        }
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }
}

