/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.service;

import com.ebmwebsourcing.webcommons.aop.annotation.CheckAllArgumentsNotNull;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupManager;
import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.Role;
import com.ebmwebsourcing.webcommons.user.persistence.bo.RoleGroup;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleGroupDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.UserDAO;
import com.ebmwebsourcing.webcommons.user.service.RolesAndUsersTransfertObjectAssembler;
import com.ebmwebsourcing.webcommons.util.StringHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class RoleGroupManagerImpl
implements RoleGroupManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    private RoleGroupDAO roleGroupDAO;
    private RoleDAO roleDAO;
    private UserDAO userDAO;
    private Resource roleGroupsResource;
    private RoleGroupManager roleGroupManager;

    public void nonTransactionalInit() throws IOException, RoleGroupException {
        this.logger.debug((Object)"###### Initialize RoleGroupManager bean");
        this.roleGroupManager.init();
        this.logger.debug((Object)"###### RoleGroupManager bean initialized");
    }

    public void setRoleGroupManager(RoleGroupManager roleGroupManager) {
        this.roleGroupManager = roleGroupManager;
    }

    public void setRoleGroupsResource(Resource roleGroupsResource) {
        this.roleGroupsResource = roleGroupsResource;
    }

    @Override
    public void init() throws IOException, RoleGroupException {
        Properties rolesGroupProps = PropertiesLoaderUtils.loadProperties((Resource)this.roleGroupsResource);
        Map<String, List<String>> roleGroupsMap = this.createRoleGroupToRoleListMap(rolesGroupProps);
        for (String roleGroup : roleGroupsMap.keySet()) {
            this.logger.debug((Object)("Create Role group : " + roleGroup));
            this.createRoleGroup(roleGroup, roleGroupsMap.get(roleGroup));
        }
    }

    private void createRoleGroup(String groupName, List<String> roleNames) throws RoleGroupException {
        RoleGroup roleGroupBO = this.roleGroupDAO.getRoleGroupByName(groupName);
        if (roleGroupBO == null) {
            RoleGroup roleGroup = new RoleGroup();
            roleGroup.setName(groupName);
            List<Role> listRoles = this.retrieveRole(roleNames);
            roleGroup.setListRoles(listRoles);
            this.roleGroupDAO.save((Object)roleGroup);
        }
    }

    private List<Role> retrieveRole(List<String> roleNames) throws RoleGroupException {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String string : roleNames) {
            Role role = this.roleDAO.getRoleByName(string);
            if (role != null) {
                roles.add(role);
                continue;
            }
            throw new RoleGroupException("Can't create role group because role '" + string + "' doesn't exist");
        }
        return roles;
    }

    private Map<String, List<String>> createRoleGroupToRoleListMap(Properties rolesGroupProps) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Object roleGroupProp : rolesGroupProps.keySet()) {
            ArrayList<String> roleList = new ArrayList<String>();
            String roles = rolesGroupProps.getProperty((String)roleGroupProp);
            StringTokenizer tokenizer = new StringTokenizer(roles, ",");
            while (tokenizer.hasMoreElements()) {
                String roleName = tokenizer.nextToken();
                roleList.add(roleName.trim());
            }
            result.put((String)roleGroupProp, roleList);
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createRoleGroup(RoleGroupTO roleGroupTO) throws RoleGroupException {
        RoleGroup roleGroup = new RoleGroup();
        this.validateBeforeSaveOrUpdate(roleGroupTO, null);
        this.rolesAndUsersTransfertObjectAssembler.toRoleGroupBO(roleGroupTO, roleGroup);
        List<Role> listRole = roleGroup.getListRoles();
        for (Role ro : listRole) {
            Role roTmp = this.roleDAO.getRoleByName(ro.getName());
            ro.setId(roTmp.getId());
        }
        return ((RoleGroup)((Object)this.roleGroupDAO.save((Object)roleGroup))).getId();
    }

    @Override
    public List<RoleGroupTO> getAllRoleGroup() throws RoleGroupException {
        List listAllGroupe = this.roleGroupDAO.getAll();
        List<RoleGroupTO> listRole = this.rolesAndUsersTransfertObjectAssembler.toAllGroupes(listAllGroupe);
        return listRole;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<RoleGroupTO> getRoleGroupNotInUser(String idUser) throws RoleGroupException {
        ArrayList<RoleGroupTO> listRoleGroupTO = new ArrayList<RoleGroupTO>();
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)idUser)));
        List<Object> listRoleGroupInUser = new ArrayList();
        if (user == null) {
            throw new RoleGroupException("A user with that name doesn't exist ! ");
        }
        listRoleGroupInUser = user.getListRoleGroup();
        List allRoleGroup = this.roleGroupDAO.getAll();
        if (allRoleGroup != null) {
            if (!listRoleGroupInUser.isEmpty()) {
                allRoleGroup.removeAll(listRoleGroupInUser);
            }
            for (RoleGroup rG : allRoleGroup) {
                listRoleGroupTO.add(this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(rG));
            }
        } else {
            throw new RoleGroupException("no role groups in database ! ");
        }
        return listRoleGroupTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public RoleGroupTO getRoleGroup(String idGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idGroup)));
        if (roleGroup == null) {
            throw new RoleGroupException("no role groups whith this id in database ! ");
        }
        RoleGroupTO role = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(roleGroup);
        return role;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRoleGroup(String idGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idGroup)));
        if (roleGroup == null) {
            throw new RoleGroupException("no role groups whith this id in database ! ");
        }
        roleGroup.clearUserList();
        this.roleGroupDAO.save((Object)roleGroup);
        this.roleGroupDAO.remove((Object)roleGroup);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateRoleGroup(RoleGroupTO roleGroupTO) throws RoleGroupException {
        String id = roleGroupTO.getId();
        if (id == null) {
            throw new RoleGroupException("this role doesn't already exist in database : ");
        }
        RoleGroup group = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)roleGroupTO.getId())));
        if (group == null) {
            throw new RoleGroupException("this role doesn't already exist in database : " + id);
        }
        this.validateBeforeSaveOrUpdate(roleGroupTO, group.getName());
        this.rolesAndUsersTransfertObjectAssembler.toRoleGroupBO(roleGroupTO, group);
        ArrayList<Role> listR = new ArrayList<Role>();
        List<Role> listRole = group.getListRoles();
        for (Role ro : listRole) {
            ro = this.roleDAO.getRoleByName(ro.getName());
            listR.add(ro);
        }
        group.setListRoles(listR);
        this.roleGroupDAO.save((Object)group);
        return group.getId();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeUser(String idUser, String idRoleGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idRoleGroup)));
        if (roleGroup == null) {
            throw new RoleGroupException("You are trying to remove a user to a non existing role whit id : " + idRoleGroup);
        }
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)idUser)));
        if (user == null) {
            throw new RoleGroupException("You are trying to remove a non existing user to a role whith id : " + idRoleGroup);
        }
        roleGroup.removeUser(user);
        this.roleGroupDAO.save((Object)roleGroup);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addUser(String idUser, String idRoleGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idRoleGroup)));
        if (roleGroup == null) {
            throw new RoleGroupException("You are trying to add a user to a non existing role whit id : " + idRoleGroup);
        }
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)idUser)));
        if (user == null) {
            throw new RoleGroupException("You are trying to add a non existing user to a role whith id : " + idRoleGroup);
        }
        roleGroup.addUser(user);
        this.roleGroupDAO.save((Object)roleGroup);
    }

    private void validateBeforeSaveOrUpdate(RoleGroupTO roleGroup, String nameRoleGroup) throws RoleGroupException {
        RoleGroup group;
        String roleGroupNameTO = roleGroup.getName();
        if (StringHelper.isNullOrEmpty((String)roleGroupNameTO)) {
            throw new RoleGroupException("Role Name must be speficied.");
        }
        if (!roleGroupNameTO.equalsIgnoreCase(nameRoleGroup) && (group = this.roleGroupDAO.getRoleGroupByName(roleGroupNameTO)) != null) {
            throw new RoleGroupException("A role with that name already exists : " + roleGroupNameTO);
        }
    }

    public void setRolesAndUsersTransfertObjectAssembler(RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler) {
        this.rolesAndUsersTransfertObjectAssembler = rolesAndUsersTransfertObjectAssembler;
    }

    public void setRoleGroupDAO(RoleGroupDAO roleGroupDAO) {
        this.roleGroupDAO = roleGroupDAO;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }
}

