/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.addressing.addressing4agreement.test;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestWSAddressingDescriptor
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public TestWSAddressingDescriptor(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderAddressing() throws URISyntaxException, WSAddressingException {
        EndpointReferenceType desc = WSAddressing4AgreementFactory.newInstance().newWSAddressing4AgreementReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"testEndpoint", (String)desc.getAddress());
        System.out.println(desc);
        System.out.println(desc.getAddress());
        System.out.println(desc.getReferenceParameters());
        System.out.println(((ReferenceParametersType)desc.getReferenceParameters()).getMonitoringPropertiesType());
        System.out.println(((ReferenceParametersType)desc.getReferenceParameters()).getMonitoringPropertiesType().getProperties().getProperty("mode"));
        System.out.println(((ReferenceParametersType)desc.getReferenceParameters()).getMonitoringPropertiesType().getProperties().getProperty("operation"));
        Assert.assertEquals((String)"pull", (String)((ReferenceParametersType)desc.getReferenceParameters()).getMonitoringPropertiesType().getProperties().getProperty("mode"));
        Assert.assertEquals((String)"speed", (String)((ReferenceParametersType)desc.getReferenceParameters()).getMonitoringPropertiesType().getProperties().getProperty("operation"));
    }

    public void testWriterAddressing() throws SchemaException, URISyntaxException, SchemaException {
        EndpointReferenceType desc = WSAddressing4AgreementFactory.newInstance().newWSAddressing4AgreementReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        String res = WSAddressing4AgreementFactory.newInstance().newWSAddressing4AgreementWriter().writeEndpointReferenceType(desc);
        Assert.assertNotNull((Object)res);
        System.out.println("xml plat:\n" + res);
        Document doc = WSAddressing4AgreementFactory.newInstance().newWSAddressing4AgreementWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testCreateAddressing() throws URISyntaxException, SchemaException {
        EndpointReferenceType desc = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
        desc.setTagQName(new QName("http://petals.ow2.org", "MyNewEndpoint"));
        desc.setAddress("myNewEndpointAddress");
        ReferenceParametersType ref = (ReferenceParametersType)desc.newReferenceParameters();
        desc.setReferenceParameters((AbsItfReferenceParametersType)ref);
        MonitoringPropertiesType properties = ref.newMonitoringPropertiesType();
        ref.setMonitoringPropertiesType(properties);
        Properties props = new Properties();
        props.put("mode", "pull");
        props.put("operation", "getData");
        properties.setProperty(props);
        Assert.assertNotNull((Object)desc);
        Document doc = WSAddressing4AgreementFactory.newInstance().newWSAddressing4AgreementWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }
}

