/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.extension.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ActionType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.test.Util;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnExtensionConstants;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestWSBaseNotificationDefinitionWithExtension
extends TestCase {
    public void testReadNotify() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Notify.xml"));
        System.out.println("\n\t ========== \n testReadNotify() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Notify descNot = WSNotificationReader.getInstance().readNotify(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check DestroyRegistration attributs value : \n ");
        Assert.assertNotNull((Object)descNot);
        List msgList = descNot.getNotificationMessage();
        Assert.assertNotNull((Object)msgList);
        for (NotificationMessageHolderType msg : msgList) {
            Message messageContent = msg.getMessage();
            Assert.assertNotNull((Object)messageContent);
            Element contentAsElt = WsnSpecificTypeHelper.getContentFromMessage((Message)messageContent);
            if (contentAsElt != null) {
                System.out.println(" notification message content : " + XMLPrettyPrinter.prettyPrint((Document)contentAsElt.getOwnerDocument()));
            }
            TopicExpressionType topic = msg.getTopic();
            Assert.assertNotNull((Object)topic);
            System.out.println(topic.getContent());
            System.out.println(topic.getDialect());
            System.out.println(topic.getTopicNameSpace());
            EndpointReferenceType producerRef = msg.getProducerReference();
            Assert.assertNotNull((Object)producerRef);
            System.out.println(producerRef.getAddress());
            ReferenceParametersType refParam = (ReferenceParametersType)producerRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            SOAParameterType soaParam = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)soaParam);
            System.out.println(soaParam.getService());
            System.out.println(soaParam.getInterface());
            System.out.println(soaParam.getEndpoint());
            EndpointReferenceType subscriptionRef = msg.getSubscriptionReference();
            Assert.assertNotNull((Object)subscriptionRef);
            System.out.println(subscriptionRef.getAddress());
            refParam = (ReferenceParametersType)subscriptionRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            soaParam = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)soaParam);
            System.out.println(soaParam.getService());
            System.out.println(soaParam.getInterface());
            System.out.println(soaParam.getEndpoint());
            ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)rUuids);
            List resourceIds = rUuids.getUuids();
            Assert.assertNotNull((Object)resourceIds);
            for (String id : resourceIds) {
                System.out.println(id);
            }
        }
    }

    public void testWriteNotif() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Notify.xml"));
        Notify descRead = WSNotificationReader.getInstance().readNotify(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeNotify(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteNotify() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateNotify() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException, ParserConfigurationException {
        Notify notifyPayload = WSNotificationFactory.getInstance().createNotify();
        NotificationMessageHolderType msg = WSNotificationFactory.getInstance().createNotificationMessageHolderType();
        Message content = WSNotificationFactory.getInstance().createMessage();
        Document docForMsgContent = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element contentOfMsg = docForMsgContent.createElementNS("http://anyUri/sample", "NotifyContent");
        contentOfMsg.setPrefix("npex");
        contentOfMsg.setTextContent("This is the message content contained in the created notification");
        WsnSpecificTypeHelper.setContentToMessage((Element)contentOfMsg, (Message)content);
        msg.setMessage(content);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*/trucMuche");
        msg.setTopic(topic);
        EndpointReferenceType registrationRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        registrationRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)registrationRef.newReferenceParameters();
        registrationRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org", "SubscriptionManagerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "SubscriptionManager"));
        soaParam.setEndpoint("SubscriptionManagerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
        msg.setSubscriptionReference(registrationRef);
        EndpointReferenceType producerRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        producerRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType refProd = (ReferenceParametersType)producerRef.newReferenceParameters();
        producerRef.setReferenceParameters((AbsItfReferenceParametersType)refProd);
        SOAParameterType soaParamProd = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParamProd.setService(new QName("http://petals.ow2.org/petals-se-notification", "NotificationBrokerService"));
        soaParamProd.setInterface(new QName("http://docs.oasis-open.org/wsn/brw-2", "NotificationBroker"));
        soaParamProd.setEndpoint("NotificationBrokerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParamProd, (ReferenceParametersType)refProd);
        msg.setProducerReference(producerRef);
        notifyPayload.addNotificationMessage(msg);
        Assert.assertNotNull((Object)notifyPayload);
        Document doc = WSNotificationWriter.getInstance().writeNotify(notifyPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateNotify() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadSubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        System.out.println("\n\t testReadSubscribe() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Subscribe.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Subscribe descSubs = WSNotificationReader.getInstance().readSubscribe(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check Subscribe attributs value : \n ");
        Assert.assertNotNull((Object)descSubs);
        EndpointReferenceType consumerRef = descSubs.getConsumerReference();
        Assert.assertNotNull((Object)consumerRef);
        Assert.assertEquals((String)"http://petals.ow2.org/cdk", (String)consumerRef.getAddress());
        System.out.println(consumerRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)consumerRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        SOAParameterType soaParam = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParam);
        Assert.assertNotNull((Object)soaParam);
        System.out.println(soaParam.getService());
        System.out.println(soaParam.getInterface());
        Assert.assertEquals((String)"NotificationConsumerEndpoint", (String)soaParam.getEndpoint());
        System.out.println(soaParam.getEndpoint());
        Assert.assertNotNull((Object)descSubs.getInitialTerminationTime());
        System.out.println("Initial Termination Time : " + descSubs.getInitialTerminationTime().toString());
        FilterType filter = descSubs.getFilter();
        Assert.assertNotNull((Object)filter);
        TopicExpressionType topic = filter.getTopicExpression();
        Assert.assertNotNull((Object)topic);
        System.out.println("topic dialect : " + topic.getDialect());
        System.out.println("topic namspace(s) : " + topic.getTopicNameSpace());
        System.out.println("topic content : " + topic.getContent());
        List msgContentList = filter.getMessageContentList();
        Assert.assertNotNull((Object)msgContentList);
        for (QueryExpressionType msgContentItem : msgContentList) {
            String currentDialect = msgContentItem.getDialect();
            System.out.println("msgCtt dialect : " + currentDialect);
            if (currentDialect.compareTo("http://www.w3.org/TR/1999/REC-xpath-19991116") == 0) {
                String xpath = WsnSpecificTypeHelper.getXpathExpression((QueryExpressionType)msgContentItem);
                System.out.println("xpath expression : " + xpath);
                continue;
            }
            SOAParameterType soaParamFromMsgContnent = WsnSpecificTypeHelper.getSOAParameter((QueryExpressionType)msgContentItem);
            Assert.assertNotNull((Object)soaParamFromMsgContnent);
            System.out.println("SOAParam from MessageContent - service - :" + soaParamFromMsgContnent.getService());
            System.out.println("SOAParam from MessageContent - interface - :" + soaParamFromMsgContnent.getInterface());
            System.out.println("SOAParam from MessageContent - endpoint - :" + soaParamFromMsgContnent.getEndpoint());
        }
        SubscriptionPolicyType policy = descSubs.getSubscriptionPolicy();
        Assert.assertNotNull((Object)policy);
        XsltStyleSheetType transformPolicy = WsnSpecificTypeHelper.getXsltStyleSheetType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)transformPolicy);
        Element sytleSheet = transformPolicy.getStyleSheet();
        Assert.assertNotNull((Object)sytleSheet);
        System.out.println("\n\t Stylesheet in policy :\n" + XMLPrettyPrinter.prettyPrint((Document)sytleSheet.getOwnerDocument()));
        ProcessPolicyType processPolicy = WsnSpecificTypeHelper.getProcessPolicyType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)processPolicy);
        List actionType = processPolicy.getAction();
        Assert.assertNotNull((Object)actionType);
        for (ActionType actionTypeItem : actionType) {
            System.out.println("ProcessPolicy content n\u00b0" + actionType.indexOf(actionTypeItem) + " : " + actionTypeItem);
        }
        ContextPolicyType contextPolicy = WsnSpecificTypeHelper.getContextPolicyType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)contextPolicy);
        System.out.println("ContextPolicy attibutes :");
        System.out.println("isCorrelationId = " + Boolean.toString(contextPolicy.isCorrelationId()));
        System.out.println("isEndpoint = " + Boolean.toString(contextPolicy.isEndpoint()));
        System.out.println("isInterface = " + Boolean.toString(contextPolicy.isInterface()));
        System.out.println("isMeuuid = " + Boolean.toString(contextPolicy.isMeuuid()));
        System.out.println("isNotifDate = " + Boolean.toString(contextPolicy.isNotifDate()));
        System.out.println("isService = " + Boolean.toString(contextPolicy.isService()));
        System.out.println("isStatus = " + Boolean.toString(contextPolicy.isStatus()));
    }

    public void testWriterSubscribe() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterSubscribe() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Subscribe.xml"));
        Subscribe subs = WSNotificationReader.getInstance().readSubscribe(docDesc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribe(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteSubscribe() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Subscribe subscribePayload = WSNotificationFactory.getInstance().createSubscribe();
        GregorianCalendar gCalendar = new GregorianCalendar();
        subscribePayload.setInitialTerminationTime(gCalendar.getTime());
        EndpointReferenceType consumerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        consumerEdpRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)consumerEdpRef.newReferenceParameters();
        consumerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org", "NotificationConsumerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
        soaParam.setEndpoint("NotificationConsumerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        subscribePayload.setConsumerReference(consumerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        QueryExpressionType msgCtt = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCtt.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        WsnSpecificTypeHelper.setXpathExpressionsType((String)"/Catalog/Album[@artist=\"Kings Of Leon\"]/Track", (QueryExpressionType)msgCtt);
        QueryExpressionType msgCttSOA = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCttSOA.setDialect("http://www.ebm.com/specific");
        SOAParameterType soaParamForMsgContent = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParamForMsgContent.setService(new QName("http://petals.ow2.org", "myService"));
        soaParamForMsgContent.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "myInterface"));
        soaParamForMsgContent.setEndpoint("myEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParamForMsgContent, (QueryExpressionType)msgCttSOA);
        FilterType filter = WSNotificationFactory.getInstance().createFiltertype();
        filter.setTopicExpression(topic);
        filter.addMessageContent(msgCtt);
        filter.addMessageContent(msgCttSOA);
        subscribePayload.setFilter(filter);
        SubscriptionPolicyType policy = WSNotificationFactory.getInstance().createSubscriptionPolicyType();
        Element elementDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/policyRule_grdr-etape1.xsl")).getDocumentElement();
        System.out.println("\n\t ========== \n xml xslt stylesheet imported :\n" + XMLPrettyPrinter.prettyPrint((Document)elementDesc.getOwnerDocument()));
        XsltStyleSheetType transformPolicy = WSNotificationExtensionFactory.getInstance().createXsltStyleSheetType();
        transformPolicy.setStyleSheet(elementDesc);
        WsnSpecificTypeHelper.setXsltStyleSheetType((XsltStyleSheetType)transformPolicy, (SubscriptionPolicyType)policy);
        ProcessPolicyType processPolicy = WSNotificationExtensionFactory.getInstance().createProcessPolicyType();
        processPolicy.addAction(ActionType.CREATE);
        WsnSpecificTypeHelper.setProcessPolicyType((ProcessPolicyType)processPolicy, (SubscriptionPolicyType)policy);
        ContextPolicyType contextPolicy = WSNotificationExtensionFactory.getInstance().createContextPolicyType();
        contextPolicy.setCorrelationId(Boolean.valueOf(true));
        contextPolicy.setEndpoint(Boolean.valueOf(true));
        contextPolicy.setInterface(Boolean.valueOf(true));
        contextPolicy.setMeuuid(Boolean.valueOf(true));
        contextPolicy.setNotifDate(Boolean.valueOf(true));
        contextPolicy.setService(Boolean.valueOf(true));
        contextPolicy.setStatus(Boolean.valueOf(true));
        subscribePayload.setSubscriptionPolicy(policy);
        Assert.assertNotNull((Object)subscribePayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscribe(subscribePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        Subscribe subs = WSNotificationReader.getInstance().readSubscribe(doc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribe(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n Read and Display the Subscribe() - payload created - :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testReadSubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/SubscribeResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadSubscribeResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        SubscribeResponse descSubsResp = WSNotificationReader.getInstance().readSubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descSubsResp);
        EndpointReferenceType susbcriptionRef = descSubsResp.getSubscriptionReference();
        Assert.assertNotNull((Object)susbcriptionRef);
        System.out.println(susbcriptionRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)susbcriptionRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        SOAParameterType soaParam = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParam);
        Assert.assertNotNull((Object)soaParam);
        System.out.println(soaParam.getService());
        System.out.println(soaParam.getInterface());
        System.out.println(soaParam.getEndpoint());
        ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParam);
        Assert.assertNotNull((Object)rUuids);
        List resourceIds = rUuids.getUuids();
        Assert.assertNotNull((Object)resourceIds);
        for (String id : resourceIds) {
            System.out.println(id);
        }
        Date currentTime = descSubsResp.getCurrentTime();
        Assert.assertNotNull((Object)currentTime);
        System.out.println("current time : " + currentTime.toString());
        Date terminationTime = descSubsResp.getTerminationTime();
        Assert.assertNotNull((Object)terminationTime);
        System.out.println("termination time : " + terminationTime.toString());
    }

    public void testWriterSubscribeResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/SubscribeResponse.xml"));
        SubscribeResponse descRead = WSNotificationReader.getInstance().readSubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribeResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteSubscribeResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException, DatatypeConfigurationException {
        SubscribeResponse subscribeResponsePayload = WSNotificationFactory.getInstance().createSubscribeResponse();
        EndpointReferenceType subscriptionRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        subscriptionRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)subscriptionRef.newReferenceParameters();
        subscriptionRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org", "SubscriptionManagerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "SubscriptionManager"));
        soaParam.setEndpoint("SubscriptionManagerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
        subscribeResponsePayload.setSubscriptionReference(subscriptionRef);
        subscribeResponsePayload.setCurrentTime(new GregorianCalendar().getTime());
        Date terminationTime = new GregorianCalendar().getTime();
        DatatypeFactory.newInstance().newDuration("PT15M30S").addTo(terminationTime);
        subscribeResponsePayload.setTerminationTime(terminationTime);
        Assert.assertNotNull((Object)subscribeResponsePayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscribeResponse(subscribeResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscribeResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadUnsubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Unsubscribe.xml"));
        System.out.println("\n\t ========== \n \n testReadUnsubscribe() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Unsubscribe descUnsubs = WSNotificationReader.getInstance().readUnsubscribe(docDesc);
        Assert.assertNotNull((Object)descUnsubs);
        EndpointReferenceType endpointRef = WsnSpecificTypeHelper.getEndpointReference((Unsubscribe)descUnsubs);
        Assert.assertNotNull((Object)endpointRef);
        String address = endpointRef.getAddress();
        Assert.assertNotNull((Object)address);
        System.out.println("Address of endpoint : " + address);
        ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType((Unsubscribe)descUnsubs);
        Assert.assertNotNull((Object)rUuids);
        List resourceIds = rUuids.getUuids();
        Assert.assertNotNull((Object)resourceIds);
        for (String id : resourceIds) {
            System.out.println(id);
        }
    }

    public void testWriterUnsubscribe() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Unsubscribe.xml"));
        Unsubscribe descRead = WSNotificationReader.getInstance().readUnsubscribe(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeUnsubscribe(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteUnsubscribe() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateUnsubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Unsubscribe unsubscribePayload = WSNotificationFactory.getInstance().createUnsubscribe();
        EndpointReferenceType edpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        edpRef.setAddress("mail-address-sample@ebmwebsourcing.com");
        WsnSpecificTypeHelper.setEndpointReference((EndpointReferenceType)edpRef, (Unsubscribe)unsubscribePayload);
        ResourcesUuidType uuidsToRemove = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        uuidsToRemove.addUuid("uuid:" + UUID.randomUUID());
        uuidsToRemove.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuidsToRemove, (Unsubscribe)unsubscribePayload);
        Document doc = WSNotificationWriter.getInstance().writeUnsubscribe(unsubscribePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadSubscriptionManagerRP() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        System.out.println("\n\t testReadSubscriptionManagerRP() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/SubscriptionManagerRP.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        SubscriptionManagerRP descSubsManRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check SubscriptionManagerRP attributs value : \n ");
        Assert.assertNotNull((Object)descSubsManRP);
        EndpointReferenceType consumerRef = descSubsManRP.getConsumerReference();
        Assert.assertNotNull((Object)consumerRef);
        Assert.assertEquals((String)"http://petals.ow2.org/cdk", (String)consumerRef.getAddress());
        System.out.println(consumerRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)consumerRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        SOAParameterType soaParam = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParam);
        Assert.assertNotNull((Object)soaParam);
        System.out.println(soaParam.getService());
        System.out.println(soaParam.getInterface());
        Assert.assertEquals((String)"NotificationConsumerEndpoint", (String)soaParam.getEndpoint());
        System.out.println(soaParam.getEndpoint());
        Assert.assertNotNull((Object)descSubsManRP.getCreationTime());
        System.out.println("subscription Creation Date : " + descSubsManRP.getCreationTime().toString());
        TerminationTimeType termTime = WsnSpecificTypeHelper.getTerminationTimeFromSubscription((SubscriptionManagerRP)descSubsManRP);
        Assert.assertNotNull((Object)termTime);
        System.out.println("subscription Termination Date :" + termTime.getValue().toString());
        FilterType filter = descSubsManRP.getFilter();
        Assert.assertNotNull((Object)filter);
        TopicExpressionType topic = filter.getTopicExpression();
        Assert.assertNotNull((Object)topic);
        System.out.println("topic dialect : " + topic.getDialect());
        System.out.println("topic namspace(s) : " + topic.getTopicNameSpace());
        System.out.println("topic content : " + topic.getContent());
        List msgContentList = filter.getMessageContentList();
        Assert.assertNotNull((Object)msgContentList);
        for (QueryExpressionType msgContentItem : msgContentList) {
            String currentDialect = msgContentItem.getDialect();
            System.out.println("msgCtt dialect : " + currentDialect);
            if (currentDialect.compareTo("http://www.w3.org/TR/1999/REC-xpath-19991116") == 0) {
                String xpath = WsnSpecificTypeHelper.getXpathExpression((QueryExpressionType)msgContentItem);
                System.out.println("xpath expression : " + xpath);
                continue;
            }
            SOAParameterType soaParamFromMsgContnent = WsnSpecificTypeHelper.getSOAParameter((QueryExpressionType)msgContentItem);
            Assert.assertNotNull((Object)soaParamFromMsgContnent);
            System.out.println("SOAParam from MessageContent - service - :" + soaParamFromMsgContnent.getService());
            System.out.println("SOAParam from MessageContent - interface - :" + soaParamFromMsgContnent.getInterface());
            System.out.println("SOAParam from MessageContent - endpoint - :" + soaParamFromMsgContnent.getEndpoint());
        }
        SubscriptionPolicyType policy = descSubsManRP.getSubscriptionPolicy();
        Assert.assertNotNull((Object)policy);
        XsltStyleSheetType transformPolicy = WsnSpecificTypeHelper.getXsltStyleSheetType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)transformPolicy);
        Element sytleSheet = transformPolicy.getStyleSheet();
        Assert.assertNotNull((Object)sytleSheet);
        System.out.println("\n\t Stylesheet in policy :\n" + XMLPrettyPrinter.prettyPrint((Document)sytleSheet.getOwnerDocument()));
        ProcessPolicyType processPolicy = WsnSpecificTypeHelper.getProcessPolicyType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)processPolicy);
        List actionType = processPolicy.getAction();
        Assert.assertNotNull((Object)actionType);
        for (ActionType actionTypeItem : actionType) {
            System.out.println("ProcessPolicy content n\u00b0" + actionType.indexOf(actionTypeItem) + " : " + actionTypeItem);
        }
        ContextPolicyType contextPolicy = WsnSpecificTypeHelper.getContextPolicyType((SubscriptionPolicyType)policy);
        Assert.assertNotNull((Object)contextPolicy);
        System.out.println("ContextPolicy attibutes :");
        System.out.println("isCorrelationId = " + Boolean.toString(contextPolicy.isCorrelationId()));
        System.out.println("isEndpoint = " + Boolean.toString(contextPolicy.isEndpoint()));
        System.out.println("isInterface = " + Boolean.toString(contextPolicy.isInterface()));
        System.out.println("isMeuuid = " + Boolean.toString(contextPolicy.isMeuuid()));
        System.out.println("isNotifDate = " + Boolean.toString(contextPolicy.isNotifDate()));
        System.out.println("isService = " + Boolean.toString(contextPolicy.isService()));
        System.out.println("isStatus = " + Boolean.toString(contextPolicy.isStatus()));
    }

    public void testWriterSubscriptionManagerRP() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterSubscriptionManagerRP() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/SubscriptionManagerRP.xml"));
        SubscriptionManagerRP subsManRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(docDesc);
        Assert.assertNotNull((Object)subsManRP);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subsManRP);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteSubscriptionManagerRP() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscriptionManagerRP() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        SubscriptionManagerRP subscriptionManagerRPPayload = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
        GregorianCalendar gCalendar = new GregorianCalendar();
        subscriptionManagerRPPayload.setCreationTime(gCalendar.getTime());
        EndpointReferenceType consumerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        consumerEdpRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)consumerEdpRef.newReferenceParameters();
        consumerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org", "NotificationConsumerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
        soaParam.setEndpoint("NotificationConsumerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        subscriptionManagerRPPayload.setConsumerReference(consumerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        QueryExpressionType msgCtt = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCtt.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        WsnSpecificTypeHelper.setXpathExpressionsType((String)"/Catalog/Album[@artist=\"Kings Of Leon\"]/Track", (QueryExpressionType)msgCtt);
        QueryExpressionType msgCttSOA = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCttSOA.setDialect("http://www.ebm.com/specific");
        SOAParameterType soaParamForMsgContent = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParamForMsgContent.setService(new QName("http://petals.ow2.org", "myService"));
        soaParamForMsgContent.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "myInterface"));
        soaParamForMsgContent.setEndpoint("myEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParamForMsgContent, (QueryExpressionType)msgCttSOA);
        FilterType filter = WSNotificationFactory.getInstance().createFiltertype();
        filter.setTopicExpression(topic);
        filter.addMessageContent(msgCtt);
        filter.addMessageContent(msgCttSOA);
        subscriptionManagerRPPayload.setFilter(filter);
        SubscriptionPolicyType policy = WSNotificationFactory.getInstance().createSubscriptionPolicyType();
        Element elementDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/policyRule_grdr-etape1.xsl")).getDocumentElement();
        System.out.println("\n\t ========== \n xml xslt stylesheet imported :\n" + XMLPrettyPrinter.prettyPrint((Document)elementDesc.getOwnerDocument()));
        XsltStyleSheetType transformPolicy = WSNotificationExtensionFactory.getInstance().createXsltStyleSheetType();
        transformPolicy.setStyleSheet(elementDesc);
        WsnSpecificTypeHelper.setXsltStyleSheetType((XsltStyleSheetType)transformPolicy, (SubscriptionPolicyType)policy);
        ProcessPolicyType processPolicy = WSNotificationExtensionFactory.getInstance().createProcessPolicyType();
        processPolicy.addAction(ActionType.CREATE);
        WsnSpecificTypeHelper.setProcessPolicyType((ProcessPolicyType)processPolicy, (SubscriptionPolicyType)policy);
        ContextPolicyType contextPolicy = WSNotificationExtensionFactory.getInstance().createContextPolicyType();
        contextPolicy.setCorrelationId(Boolean.valueOf(true));
        contextPolicy.setEndpoint(Boolean.valueOf(true));
        contextPolicy.setInterface(Boolean.valueOf(true));
        contextPolicy.setMeuuid(Boolean.valueOf(true));
        contextPolicy.setNotifDate(Boolean.valueOf(true));
        contextPolicy.setService(Boolean.valueOf(true));
        contextPolicy.setStatus(Boolean.valueOf(true));
        subscriptionManagerRPPayload.setSubscriptionPolicy(policy);
        TerminationTimeType termTime = WSNotificationExtensionFactory.getInstance().createTerminationTimeType();
        termTime.setValue(new GregorianCalendar().getTime());
        WsnSpecificTypeHelper.setTerminationTimeToSubscription((TerminationTimeType)termTime, (SubscriptionManagerRP)subscriptionManagerRPPayload);
        Assert.assertNotNull((Object)subscriptionManagerRPPayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subscriptionManagerRPPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscriptionManagerRP() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        SubscriptionManagerRP subs = WSNotificationReader.getInstance().readSubscriptionManagerRP(doc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n Read and Display the SubscriptionManagerRP() - payload created - :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testReadRenew() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Renew.xml"));
        System.out.println("\n\t ========== \n \n testReadRenew() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Renew descRenew = WSNotificationReader.getInstance().readRenew(docDesc);
        ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((Renew)descRenew);
        Assert.assertNotNull((Object)uuids);
        System.out.println("subscription id : " + (String)uuids.getUuids().get(0));
        Assert.assertNotNull((Object)descRenew);
        System.out.println("new termination time : " + descRenew.getTerminationTime());
    }

    public void testWriterRenew() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Renew.xml"));
        Renew descRead = WSNotificationReader.getInstance().readRenew(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeRenew(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteRenew() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRenewWithDate() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException, WSNotificationExtensionException {
        Renew renewPayload = WSNotificationFactory.getInstance().createRenew();
        ResourcesUuidType uuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        uuids.addUuid(UUID.randomUUID().toString());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuids, (Renew)renewPayload);
        Date termTimeVal = new GregorianCalendar().getTime();
        DatatypeFactory.newInstance().newDuration("P1YT35M").addTo(termTimeVal);
        renewPayload.setTerminationTime(termTimeVal);
        Document doc = WSNotificationWriter.getInstance().writeRenew(renewPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testCreateRenewWithDuration() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException, WSNotificationExtensionException {
        Renew renewPayload = WSNotificationFactory.getInstance().createRenew();
        ResourcesUuidType uuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        uuids.addUuid(UUID.randomUUID().toString());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuids, (Renew)renewPayload);
        Duration termTimeVal = DatatypeFactory.newInstance().newDuration("PT35M");
        renewPayload.setTerminationTime(termTimeVal);
        Document doc = WSNotificationWriter.getInstance().writeRenew(renewPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadQueryExpression() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/MessageContent.xml"));
        System.out.println("\n\t ========== \n \n testReadQueryExpression() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        QueryExpressionType descQueryExpr = WSNotificationReader.getInstance().readQueryExpressionType(docDesc);
        Assert.assertNotNull((Object)descQueryExpr);
        System.out.println("Dialect : " + descQueryExpr.getDialect());
        System.out.println("message content value : " + descQueryExpr.getContent());
    }

    public void testWriterQueryExpression() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/MessageContent.xml"));
        QueryExpressionType descRead = WSNotificationReader.getInstance().readQueryExpressionType(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeQueryExpressionType(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteQueryExpression() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateQueryExpression() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        QueryExpressionType msgContent = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgContent.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        QName xpathExprEltQName = WsnExtensionConstants.XPATHS_QNAME;
        JAXBElement xpathExpElt = WSNotificationFactory.getInstance().createStringJaxbElt(xpathExprEltQName, "/Catalog/Album[@artist=\"Kings Of Leon\"]/Track");
        msgContent.addContent((Object)xpathExpElt);
        Document doc = WSNotificationWriter.getInstance().writeQueryExpressionType(msgContent);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateQueryExpression() - created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testPersistAndRestoreSubsciptionRP() {
        try {
            File[] storedRegFiles;
            String tempDirName = "tmp" + File.separatorChar;
            String persistenceRepositoryName = tempDirName + "SaveSubscriptionManagerRP" + File.separatorChar;
            File persistenceRepository = new File(persistenceRepositoryName);
            persistenceRepository.mkdirs();
            Document request = Util.fromStreamToDocument(TestWSBaseNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/Subscribe.xml"));
            Subscribe subsPayload = WSNotificationReader.getInstance().readSubscribe(request);
            SubscriptionManagerRP subscriptionToPersist = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
            subscriptionToPersist.setConsumerReference(subsPayload.getConsumerReference());
            FilterType ft = subsPayload.getFilter();
            subscriptionToPersist.setFilter(ft);
            subscriptionToPersist.setSubscriptionPolicy(subsPayload.getSubscriptionPolicy());
            int nbOfReg = new Random().nextInt(5) + 1;
            System.out.println("[INFO : generate " + nbOfReg + " registration to store)");
            Date now = null;
            String initTermTime = subsPayload.getInitialTerminationTime();
            for (int i = 0; i < nbOfReg; ++i) {
                now = new GregorianCalendar().getTime();
                subscriptionToPersist.setCreationTime(new GregorianCalendar().getTime());
                TerminationTimeType termTime = WSNotificationExtensionFactory.getInstance().createTerminationTimeType();
                Date termTimeValue = null;
                if (initTermTime.startsWith("P")) {
                    Duration duration = DatatypeFactory.newInstance().newDuration(initTermTime);
                    termTimeValue = now;
                    duration.addTo(termTimeValue);
                } else {
                    termTimeValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(initTermTime).toGregorianCalendar().getTime();
                }
                termTime.setValue(termTimeValue);
                WsnSpecificTypeHelper.setTerminationTimeToSubscription((TerminationTimeType)termTime, (SubscriptionManagerRP)subscriptionToPersist);
                File fileToSaveTo = new File("tmp" + File.separatorChar + "SaveSubscriptionManagerRP" + File.separatorChar + UUID.randomUUID());
                WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subscriptionToPersist, fileToSaveTo);
            }
            if (persistenceRepository.exists() && persistenceRepository.isDirectory()) {
                File[] persistedSubscriptions = persistenceRepository.listFiles();
                Document docRep = null;
                System.out.println(" ########### Liste des subscription restaur\u00e9es : ###########");
                for (int i = 0; i < persistedSubscriptions.length; ++i) {
                    SubscriptionManagerRP subsRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(persistedSubscriptions[i]);
                    docRep = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subsRP);
                    System.out.println(" ########## Restored Subscription " + persistedSubscriptions[i].getName() + ":\n\n" + XMLPrettyPrinter.prettyPrint((Document)docRep) + "\n");
                }
                System.out.println(" ########### Fin de List  ###########");
            }
            for (File fileItem : storedRegFiles = persistenceRepository.listFiles()) {
                fileItem.delete();
            }
            persistenceRepository.delete();
            new File(tempDirName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

