/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.test.BrokeredNotificationService;
import com.ebmwebsourcing.wsstar.notification.service.test.Util;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;

public class TestBrokeredNotificationService
extends TestCase {
    protected BrokeredNotificationService wsnbrService;
    protected WSNotificationReader wsnReader = null;
    private WSNotificationWriter wsnWriter = null;

    protected void setUp() throws Exception {
        System.out.println("\n\t ========== \n\t ~ Init BrokeredNotification ~ ...");
        InputStream supportedTopicsConfig = TestBrokeredNotificationService.class.getResourceAsStream("/models/SupportedTopicsSet.xml");
        this.wsnbrService = new BrokeredNotificationService(Logger.getLogger("TestBrokerNotificationService Component"), supportedTopicsConfig);
        this.wsnReader = WSNotificationReader.getInstance();
        this.wsnWriter = WSNotificationWriter.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterPublisherRequest() throws URISyntaxException, WSNotificationException, WSNotificationExtensionException {
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            RegisterPublisher reqObj = this.wsnReader.readRegisterPublisher(request);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            RegisterPublisherResponse reqRespObj = this.wsnbrService.registerPublisher(reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            response = this.wsnWriter.writeRegisterPublisherResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterPublisherRequestWithSubscriptionsToForward() throws URISyntaxException, WSNotificationException, WSNotificationExtensionException {
        SubscribeResponse reqRespObj;
        Subscribe reqObj;
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(request);
            reqRespObj = this.wsnbrService.subscribe(reqObj);
            response = this.wsnWriter.writeSubscribeResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        try {
            request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        }
        catch (URISyntaxException e) {
            TestBrokeredNotificationService.fail((String)e.getMessage());
        }
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readRegisterPublisher(request);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            reqRespObj = this.wsnbrService.registerPublisher((RegisterPublisher)reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            response = this.wsnWriter.writeRegisterPublisherResponse((RegisterPublisherResponse)reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            response = wsnFault.getDocumentFragment();
        }
        catch (WSNotificationException e) {
            TestBrokeredNotificationService.fail((String)e.getMessage());
        }
        finally {
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyExistingRegistrationRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document requestRegPub = null;
        Document response = null;
        requestRegPub = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)requestRegPub);
        System.out.println(" *** Xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)requestRegPub) + "\n");
        try {
            RegisterPublisher reqObj = this.wsnReader.readRegisterPublisher(requestRegPub);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            RegisterPublisherResponse reqRespObj = this.wsnbrService.registerPublisher(reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            List resourceIds = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)reqRespObj.getPublisherRegistrationReference().getReferenceParameters())).getUuids();
            for (String id : resourceIds) {
                System.out.println("resourceId : " + id);
            }
            System.out.println(" *** Supported topics set before destuction (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
            DestroyRegistration requestDestroyRegistration = WSNotificationFactory.getInstance().createDestroyRegistration();
            TestBrokeredNotificationService.assertNotNull((Object)requestDestroyRegistration);
            EndpointReferenceType registrationRef = reqRespObj.getPublisherRegistrationReference();
            Assert.assertNotNull((Object)registrationRef);
            ReferenceParametersType refParam = (ReferenceParametersType)registrationRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            ResourcesUuidType registrationUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)registrationUuids);
            EndpointReferenceType subscriptionManagerRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
            ReferenceParametersType smRefParam = (ReferenceParametersType)subscriptionManagerRef.newReferenceParameters();
            SOAParameterType smSoaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
            smSoaParam.setEndpoint("smEndpoint");
            smSoaParam.setService(new QName("http://docs.oasis-open.org/wsn/b-2", "SubscriptionManagerService"));
            smSoaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/b-2", "SubscriptionManager"));
            WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)smSoaParam, (ReferenceParametersType)smRefParam);
            subscriptionManagerRef.setReferenceParameters((AbsItfReferenceParametersType)smRefParam);
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)registrationUuids, (DestroyRegistration)requestDestroyRegistration);
            Document doc = WSNotificationWriter.getInstance().writeDestroyRegistration(requestDestroyRegistration);
            TestBrokeredNotificationService.assertNotNull((Object)doc);
            System.out.println("\n *** DestroyRegistration request created and processed :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            DestroyRegistration reqObjBis = this.wsnReader.readDestroyRegistration(doc);
            TestBrokeredNotificationService.assertNotNull((Object)reqObjBis);
            DestroyRegistrationResponse reqRespObjBis = this.wsnbrService.destroyRegistration(reqObjBis);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObjBis);
            response = this.wsnWriter.writeDestroyRegistrationResponse(reqRespObjBis);
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyUnknownRegistrationsRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/DestroyRegistration.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            DestroyRegistration reqObj = this.wsnReader.readDestroyRegistration(request);
            DestroyRegistrationResponse reqRespObj = this.wsnbrService.destroyRegistration(reqObj);
            response = this.wsnWriter.writeDestroyRegistrationResponse(reqRespObj);
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubscribeRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            Subscribe reqObj = this.wsnReader.readSubscribe(request);
            SubscribeResponse reqRespObj = this.wsnbrService.subscribe(reqObj);
            response = this.wsnWriter.writeSubscribeResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForwardOfSubscribeRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        RegisterPublisherResponse reqRespObj;
        RegisterPublisher reqObj;
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readRegisterPublisher(request);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            reqRespObj = this.wsnbrService.registerPublisher(reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            response = this.wsnWriter.writeRegisterPublisherResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** RegistrationResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegistrationResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** RegistrationResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(request);
            reqRespObj = this.wsnbrService.subscribe((Subscribe)reqObj);
            response = this.wsnWriter.writeSubscribeResponse((SubscribeResponse)reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            response = wsnFault.getDocumentFragment();
        }
        finally {
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForwardOfSubscribeOnRegisterPublisherRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        SubscribeResponse reqRespObj;
        Subscribe reqObj;
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(request);
            reqRespObj = this.wsnbrService.subscribe(reqObj);
            response = this.wsnWriter.writeSubscribeResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** SubsrcibeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readRegisterPublisher(request);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            reqRespObj = this.wsnbrService.registerPublisher((RegisterPublisher)reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            response = this.wsnWriter.writeRegisterPublisherResponse((RegisterPublisherResponse)reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            response = wsnFault.getDocumentFragment();
        }
        finally {
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegistrationResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnsubscribeToExistingSubscriptionRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document requestSubs = null;
        Document response = null;
        requestSubs = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)requestSubs);
        System.out.println(" *** Xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)requestSubs) + "\n");
        try {
            Subscribe reqObj = this.wsnReader.readSubscribe(requestSubs);
            SubscribeResponse reqRespObj = this.wsnbrService.subscribe(reqObj);
            List resourceIds = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)reqRespObj.getSubscriptionReference().getReferenceParameters())).getUuids();
            for (String id : resourceIds) {
                System.out.println("resourceId : " + id);
            }
            System.out.println(" *** Supported topics set before Unsubscribe request (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
            Unsubscribe requestUnsubscribe = WSNotificationFactory.getInstance().createUnsubscribe();
            EndpointReferenceType registrationRef = reqRespObj.getSubscriptionReference();
            Assert.assertNotNull((Object)registrationRef);
            ReferenceParametersType refParam = (ReferenceParametersType)registrationRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            ResourcesUuidType uuidsToRemove = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)uuidsToRemove);
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuidsToRemove, (Unsubscribe)requestUnsubscribe);
            Document doc = WSNotificationWriter.getInstance().writeUnsubscribe(requestUnsubscribe);
            TestBrokeredNotificationService.assertNotNull((Object)doc);
            System.out.println("\n *** Unsubscribe request created and processed :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            Unsubscribe reqObjBis = this.wsnReader.readUnsubscribe(doc);
            UnsubscribeResponse reqRespObjBis = this.wsnbrService.unsubscribe(reqObjBis);
            response = this.wsnWriter.writeUnsubscribeResponse(reqRespObjBis);
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** unsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** unsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** unsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnsubscribeToUnknownSubscriptionRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Unsubscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            Unsubscribe reqObj = this.wsnReader.readUnsubscribe(request);
            UnsubscribeResponse reqRespObj = this.wsnbrService.unsubscribe(reqObj);
            response = this.wsnWriter.writeUnsubscribeResponse(reqRespObj);
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** UnsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** UnsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** UnsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForwardUnsubscribeRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        RegisterPublisherResponse reqRespObj;
        RegisterPublisher reqObj;
        Document requestSubs = null;
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/RegisterPublisher.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readRegisterPublisher(request);
            TestBrokeredNotificationService.assertNotNull((Object)reqObj);
            reqRespObj = this.wsnbrService.registerPublisher(reqObj);
            TestBrokeredNotificationService.assertNotNull((Object)reqRespObj);
            response = this.wsnWriter.writeRegisterPublisherResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** RegisterPublisherResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        requestSubs = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)requestSubs);
        System.out.println(" *** Xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)requestSubs) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(requestSubs);
            reqRespObj = this.wsnbrService.subscribe((Subscribe)reqObj);
            List resourceIds = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)reqRespObj.getSubscriptionReference().getReferenceParameters())).getUuids();
            for (String id : resourceIds) {
                System.out.println("resourceId : " + id);
            }
            System.out.println(" *** Supported topics set before Unsubscribe request (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
            Unsubscribe requestUnsubscribe = WSNotificationFactory.getInstance().createUnsubscribe();
            EndpointReferenceType subscriptionRef = reqRespObj.getSubscriptionReference();
            Assert.assertNotNull((Object)subscriptionRef);
            ReferenceParametersType refParam = (ReferenceParametersType)subscriptionRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            ResourcesUuidType uuidsToRemove = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParam);
            Assert.assertNotNull((Object)uuidsToRemove);
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuidsToRemove, (Unsubscribe)requestUnsubscribe);
            Document doc = WSNotificationWriter.getInstance().writeUnsubscribe(requestUnsubscribe);
            TestBrokeredNotificationService.assertNotNull((Object)doc);
            System.out.println("\n *** Unsubscribe request created and processed :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            Unsubscribe reqObjBis = this.wsnReader.readUnsubscribe(doc);
            UnsubscribeResponse reqRespObjBis = this.wsnbrService.unsubscribe(reqObjBis);
            response = this.wsnWriter.writeUnsubscribeResponse(reqRespObjBis);
        }
        catch (WSNotificationFault wsnFault) {
            response = wsnFault.getDocumentFragment();
        }
        finally {
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** unsubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotifyRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Subscribe reqObj;
        Document request = null;
        Document response = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(request);
            SubscribeResponse reqRespObj = this.wsnbrService.subscribe(reqObj);
            response = this.wsnWriter.writeSubscribeResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        request = null;
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Notify.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        reqObj = this.wsnReader.readNotify(request);
        TestBrokeredNotificationService.assertNotNull((Object)reqObj);
        this.wsnbrService.notify((Notify)reqObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCurrentMessageRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document request = null;
        Document response = null;
        try {
            request = null;
            request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Notify.xml").toURI());
            TestBrokeredNotificationService.assertNotNull((Object)request);
            Notify notifyPayload = WSNotificationReader.getInstance().readNotify(request);
            TestBrokeredNotificationService.assertNotNull((Object)notifyPayload);
            List notifMsgs = notifyPayload.getNotificationMessage();
            for (NotificationMessageHolderType notificationMsgItem : notifMsgs) {
                this.wsnbrService.setCurrentNotifyMessage(notificationMsgItem.getTopic(), notificationMsgItem.getMessage());
            }
            request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/GetCurrentMessage.xml").toURI());
            TestBrokeredNotificationService.assertNotNull((Object)request);
            System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
            GetCurrentMessage getCurMsgObj = WSNotificationReader.getInstance().readGetCurrentMessage(request);
            TestBrokeredNotificationService.assertNotNull((Object)getCurMsgObj);
            GetCurrentMessageResponse getCurMsgResp = this.wsnbrService.getCurrentMessage(getCurMsgObj);
            response = WSNotificationWriter.getInstance().writeGetCurrentMessageResponse(getCurMsgResp);
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** GetCurrentMessageResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** GetCurrentMessageResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** GetCurrentMessageResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenewRequest() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Subscribe reqObj;
        Document request = null;
        Document response = null;
        String uuidForRenew = "";
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Subscribe.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
        try {
            reqObj = this.wsnReader.readSubscribe(request);
            SubscribeResponse reqRespObj = this.wsnbrService.subscribe(reqObj);
            ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)reqRespObj.getSubscriptionReference().getReferenceParameters()));
            uuidForRenew = (String)uuids.getUuids().get(0);
            response = this.wsnWriter.writeSubscribeResponse(reqRespObj);
            System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(this.wsnbrService.getWstopTopicsMgr().getSupportedTopics()));
        }
        catch (WSNotificationFault wsnFault) {
            try {
                response = wsnFault.getDocumentFragment();
            }
            catch (Throwable throwable) {
                TestBrokeredNotificationService.assertNotNull(response);
                System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
                throw throwable;
            }
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
        TestBrokeredNotificationService.assertNotNull((Object)response);
        System.out.println("\n *** SubscribeResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        request = Util.convertFromUriToDocument(TestBrokeredNotificationService.class.getResource("/models/Renew.xml").toURI());
        TestBrokeredNotificationService.assertNotNull((Object)request);
        try {
            reqObj = this.wsnReader.readRenew(request);
            ResourcesUuidType uuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
            uuids.addUuid(uuidForRenew);
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuids, (Renew)reqObj);
            request = this.wsnWriter.writeRenew((Renew)reqObj);
            System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)request) + "\n");
            RenewResponse reqRespObj = this.wsnbrService.renew((Renew)reqObj);
            response = this.wsnWriter.writeRenewResponse(reqRespObj);
        }
        catch (WSNotificationFault wsnFault) {
            response = wsnFault.getDocumentFragment();
        }
        finally {
            TestBrokeredNotificationService.assertNotNull((Object)response);
            System.out.println("\n *** RenewResponse returned :\n" + XMLPrettyPrinter.prettyPrint((Document)response));
        }
    }
}

