/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.test.Util;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TestTopicManagerComponent
extends TestCase {
    TopicNamespaceType topicNS;
    Document topicNSString;
    WstopTopicManager topicsMgr;

    protected void setUp() throws Exception {
        System.out.println("\n\t ========== \n\t ~ Init Supported Topics set ~ ...");
        Document defaultSupportedtopicSet = null;
        this.topicsMgr = new WstopTopicManager(TestTopicManagerComponent.class.getResourceAsStream("/models/SupportedTopicsSet.xml"));
        defaultSupportedtopicSet = this.topicsMgr.getSupportedTopics();
        Assert.assertNotNull((Object)defaultSupportedtopicSet);
        System.out.println(" *** Supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(defaultSupportedtopicSet));
    }

    private Document convertFromUriToJDocument(String path) {
        Document result = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            result = builder.build(new File(path));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckTopicExpression() throws WSNotificationException, URISyntaxException {
        System.out.println("\t\t ~~ TEST \"testCheckTopicExpression()\" ~~\n");
        boolean isValideExpression = false;
        boolean resultExpected = false;
        TopicExpressionType topicExpr = null;
        Document request = null;
        request = this.convertFromUriToJDocument(TestTopicManagerComponent.class.getResource("/models/TopicExpressionsToCheck.xml").getPath());
        Assert.assertNotNull((Object)request);
        Element root = request.getRootElement();
        List unitTestList = root.getChildren("Test");
        List ns = null;
        String dialect = "";
        String content = "";
        String expValidResult = "";
        for (Object item : unitTestList) {
            content = ((Element)item).getChildText("TopicExpression");
            ns = ((Element)item).getChild("TopicExpression").getAdditionalNamespaces();
            dialect = ((Element)item).getChild("TopicExpression").getAttributeValue("Dialect");
            expValidResult = ((Element)item).getChildText("ResultExpected");
            System.out.println("\n --- test unit : Input parameters : ");
            System.out.println("Topic Expression Namespace : " + ns);
            System.out.println("Topic Expression Dialect : " + dialect);
            System.out.println("Topic Expression Content : " + content);
            System.out.println("Expected Validation Result : " + expValidResult);
            topicExpr = WSNotificationFactory.getInstance().createTopicExpressionType();
            for (Object nsItem : ns) {
                topicExpr.addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());
            }
            topicExpr.setDialect(dialect);
            topicExpr.setContent(content);
            resultExpected = Boolean.parseBoolean(expValidResult);
            try {
                isValideExpression = this.topicsMgr.acceptSubscribeOrRegisterTopicExpression(topicExpr, true) == resultExpected;
                System.out.println("Topic Expression \"" + topicExpr.getContent() + "\" has been checked without problems !");
            }
            catch (WSNotificationException e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            catch (WSNotificationFault e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            finally {
                if (isValideExpression) {
                    System.out.println("\n ---> Test Passed !\n\t ~~~~~~~");
                    continue;
                }
                System.out.println("\n ---> Test Failed !\n\t ~~~~~~~");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreNewRegistration() throws WSNotificationException, URISyntaxException {
        System.out.println("\t\t ~~ TEST \"testStoreNewRegistration()\" ~~\n");
        boolean isValideExpression = true;
        String resourceIdToStore = "";
        TopicExpressionType topicExpr = null;
        Document request = null;
        request = this.convertFromUriToJDocument(TestTopicManagerComponent.class.getResource("/models/NewRegistrationToStore.xml").getPath());
        Assert.assertNotNull((Object)request);
        Element root = request.getRootElement();
        List unitTestList = root.getChildren("Test");
        List ns = null;
        String dialect = "";
        String content = "";
        for (Object item : unitTestList) {
            content = ((Element)item).getChildText("TopicExpression");
            ns = ((Element)item).getChild("TopicExpression").getAdditionalNamespaces();
            dialect = ((Element)item).getChild("TopicExpression").getAttributeValue("Dialect");
            resourceIdToStore = ((Element)item).getChildText("RegistrationId");
            System.out.println("\n --- test unit : Input parameters : ");
            System.out.println("Topic Expression Namespace : " + ns);
            System.out.println("Topic Expression Dialect : " + dialect);
            System.out.println("Topic Expression Content : " + content);
            System.out.println("ResourceId To Store : " + resourceIdToStore);
            topicExpr = WSNotificationFactory.getInstance().createTopicExpressionType();
            for (Object nsItem : ns) {
                topicExpr.addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());
            }
            topicExpr.setDialect(dialect);
            topicExpr.setContent(content);
            try {
                this.topicsMgr.storeNewRegistration(topicExpr, resourceIdToStore);
                System.out.println("The request to store ne registration \"" + resourceIdToStore + "\" has been performed without problems !");
                Document currentStateOfSupportedTopics = this.topicsMgr.getSupportedTopics();
                System.out.println(" *** Supported topics (imported from xml document) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(currentStateOfSupportedTopics));
            }
            catch (WSNotificationException e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            catch (WSNotificationFault e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            finally {
                if (isValideExpression) {
                    System.out.println("\n ---> Test Passed !\n\t ~~~~~~~");
                    continue;
                }
                System.out.println("\n ---> Test Failed !\n\t ~~~~~~~");
            }
        }
    }

    public void testRemoveRegistration() throws WSNotificationException, URISyntaxException {
        System.out.println("\t\t ~~ TEST \"testRemoveRegistration()\" ~~\n");
        String resourceIdToRemove = "";
        Document request = null;
        request = this.convertFromUriToJDocument(TestTopicManagerComponent.class.getResource("/models/RegistrationToRemove.xml").getPath());
        Assert.assertNotNull((Object)request);
        Element root = request.getRootElement();
        List unitTestList = root.getChildren("Test");
        for (Object item : unitTestList) {
            resourceIdToRemove = ((Element)item).getChildText("RegistrationId");
            System.out.println("ResourceId To Remove : " + resourceIdToRemove);
            try {
                this.topicsMgr.removeExistingRegistration(resourceIdToRemove);
                System.out.println("The request to store ne registration \"" + resourceIdToRemove + "\" has been performed without problems !");
                Document currentStateOfSupportedTopics = this.topicsMgr.getSupportedTopics();
                System.out.println(" *** Supported topics (imported from xml document) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(currentStateOfSupportedTopics));
            }
            catch (WSNotificationException e) {
                e.printStackTrace();
            }
            catch (WSNotificationFault e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreNewSubscription() throws WSNotificationException, URISyntaxException {
        System.out.println("\t\t ~~ TEST \"testStoreNewSubscription()\" ~~\n");
        boolean isValideExpression = true;
        String resourceIdToStore = "";
        TopicExpressionType topicExpr = null;
        Document request = null;
        request = this.convertFromUriToJDocument(TestTopicManagerComponent.class.getResource("/models/NewSubscriptionToStore.xml").getPath());
        Assert.assertNotNull((Object)request);
        Element root = request.getRootElement();
        List unitTestList = root.getChildren("Test");
        List ns = null;
        String dialect = "";
        String content = "";
        for (Object item : unitTestList) {
            content = ((Element)item).getChildText("TopicExpression");
            ns = ((Element)item).getChild("TopicExpression").getAdditionalNamespaces();
            dialect = ((Element)item).getChild("TopicExpression").getAttributeValue("Dialect");
            resourceIdToStore = ((Element)item).getChildText("SubscriptionId");
            System.out.println("\n --- test unit : Input parameters : ");
            System.out.println("Topic Expression Namespace : " + ns);
            System.out.println("Topic Expression Dialect : " + dialect);
            System.out.println("Topic Expression Content : " + content);
            System.out.println("SubscriptionId To Store : " + resourceIdToStore);
            topicExpr = WSNotificationFactory.getInstance().createTopicExpressionType();
            for (Object nsItem : ns) {
                topicExpr.addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());
            }
            topicExpr.setDialect(dialect);
            topicExpr.setContent(content);
            try {
                this.topicsMgr.storeNewSubscription(topicExpr, resourceIdToStore);
                System.out.println("The request to store ne registration \"" + resourceIdToStore + "\" has been performed without problems !");
                Document currentStateOfSupportedTopics = this.topicsMgr.getSupportedTopics();
                System.out.println(" *** Supported topics (imported from xml document) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(currentStateOfSupportedTopics));
            }
            catch (WSNotificationException e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            catch (WSNotificationFault e) {
                e.printStackTrace();
                isValideExpression = false;
            }
            finally {
                if (isValideExpression) {
                    System.out.println("\n ---> Test Passed !\n\t ~~~~~~~");
                    continue;
                }
                System.out.println("\n ---> Test Failed !\n\t ~~~~~~~");
            }
        }
    }

    public void testGetSubscriptionIdsFromTopicsSet() throws WSNotificationException, URISyntaxException {
        boolean resultExpected = false;
        TopicExpressionType notifyTopicExpr = WSNotificationFactory.getInstance().createTopicExpressionType();
        List subscriptionIdsFound = null;
        Document request = null;
        request = this.convertFromUriToJDocument(TestTopicManagerComponent.class.getResource("/models/NotifyTopicExpressionsToCheck.xml").getPath());
        Assert.assertNotNull((Object)request);
        Element root = request.getRootElement();
        List unitTestList = root.getChildren("Test");
        List ns = null;
        String dialect = "";
        String content = "";
        String expValidResult = "";
        for (Object item : unitTestList) {
            content = ((Element)item).getChildText("TopicExpression");
            ns = ((Element)item).getChild("TopicExpression").getAdditionalNamespaces();
            dialect = ((Element)item).getChild("TopicExpression").getAttributeValue("Dialect");
            expValidResult = ((Element)item).getChildText("ResultExpected");
            System.out.println("\n --- test unit : Input parameters : ");
            System.out.println("Topic Expression Namespace : " + ns);
            System.out.println("Topic Expression Dialect : " + dialect);
            System.out.println("Topic Expression Content : " + content);
            System.out.println("Expected Validation Result : " + expValidResult);
            for (Object nsItem : ns) {
                notifyTopicExpr.addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());
            }
            notifyTopicExpr.setDialect(dialect);
            notifyTopicExpr.setContent(content);
            resultExpected = Boolean.parseBoolean(expValidResult);
            try {
                subscriptionIdsFound = this.topicsMgr.getSubscriptionIdsFromTopicsSet(notifyTopicExpr, true);
                Assert.assertNotNull((Object)subscriptionIdsFound);
                System.out.println("List of subscriptionIds found (no subscriptions if empty) : \n");
                for (String subId : subscriptionIdsFound) {
                    System.out.println(subId);
                }
            }
            catch (WSNotificationException e) {
                e.printStackTrace();
            }
        }
    }

    public void testCreateTopicSetFromSupportedTopicNamespace() throws WSNotificationException, URISyntaxException {
        org.w3c.dom.Document docDesc = Util.convertFromUriToDocument(TestTopicManagerComponent.class.getResource("/topicNamespace/wsdm-mows-events-with-supported-attr.xml").toURI());
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)docDesc));
        TopicNamespaceType descTN = WSNotificationReader.getInstance().readTopicNamespaceType(docDesc);
        TopicSetType topicSet = this.topicsMgr.createTopicSetFromSupportedTopicNamespace(descTN);
        TestTopicManagerComponent.assertNotNull((Object)topicSet);
        org.w3c.dom.Document docTopic = WSNotificationWriter.getInstance().writeTopicSetType(topicSet);
        System.out.println("\n\t ========== \n TopicSet: \n" + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)docTopic));
    }

    public void testCreateTopicSetFromTopicNamespace() throws WSNotificationException, URISyntaxException {
        org.w3c.dom.Document docDesc = Util.convertFromUriToDocument(TestTopicManagerComponent.class.getResource("/topicNamespace/wsdm-mows-events.xml").toURI());
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)docDesc));
        TopicNamespaceType descTN = WSNotificationReader.getInstance().readTopicNamespaceType(docDesc);
        TopicSetType topicSet = this.topicsMgr.createTopicSetFromTopicNamespace(descTN, new ArrayList<String>(Arrays.asList("MetricsCapability", "RequestReceived")));
        TestTopicManagerComponent.assertNotNull((Object)topicSet);
        org.w3c.dom.Document docTopic = WSNotificationWriter.getInstance().writeTopicSetType(topicSet);
        System.out.println("\n\t ========== \n TopicSet: \n" + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)docTopic));
    }

    public void testWstopTopicManagerInstance() throws WSNotificationException, URISyntaxException {
        WstopTopicManager myManager = new WstopTopicManager(TestTopicManagerComponent.class.getResourceAsStream("/topicNamespace/wsdm-mows-events.xml"), new ArrayList<String>(Arrays.asList("MetricsCapability", "RequestReceived")));
        TestTopicManagerComponent.assertNotNull((Object)myManager.getSupportedTopics());
        System.out.println("\n\t ========== \n TopicSet: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(myManager.getSupportedTopics()));
    }

    public void testGetTopicSetPath() throws WSNotificationException, URISyntaxException {
        this.topicsMgr.RAZSupportedTopicSet(TestTopicManagerComponent.class.getResourceAsStream("/models/CurrentStateOfTopicsSet.xml"));
        Document defaultSupportedtopicSet = this.topicsMgr.getSupportedTopics();
        Assert.assertNotNull((Object)defaultSupportedtopicSet);
        System.out.println(" *** Current supported topics set (from WstopTopicManager) :\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(defaultSupportedtopicSet));
        System.out.println("\t\t ~~ TEST \"testGetTopicSetPath()\" ~~\n");
        String subsUuid = "uuid:00000000-1111-aaaa-ffff-010101afafaf";
        List res = this.topicsMgr.getTopicSetPath(subsUuid);
        System.out.println("\t--- Resultats : ---\n");
        for (TopicExpressionType topicExpressionType : res) {
            System.out.println("topic expression -- dialect : " + topicExpressionType.getDialect());
            System.out.println("topic expression -- topic namespace(s) : " + topicExpressionType.getTopicNameSpace());
            System.out.println("topic expression -- content : " + topicExpressionType.getContent());
            System.out.println("~~~~~~~~~~~");
        }
    }
}

