/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.servicebus.cronclient;

import eu.playproject.servicebus.cronclient.CronClientImpl;
import eu.playproject.servicebus.cronclient.WSNCronClient;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.servicepoller.api.CronExpressionValidator;
import org.petalslink.dsb.servicepoller.api.ServicePollerException;
import org.petalslink.dsb.servicepoller.api.ServicePollerInformation;
import org.petalslink.dsb.servicepoller.client.WSNPollerClient;
import org.petalslink.dsb.ws.api.SOAPServiceBinder;
import org.petalslink.dsb.ws.api.ServiceEndpoint;
import org.w3c.dom.Document;

public class WSNCronClientImpl
implements WSNCronClient {
    private static Logger logger = Logger.getLogger(CronClientImpl.class.getName());
    private String url;
    private WSNPollerClient servicePollerClient;
    private SOAPServiceBinder client;

    public WSNCronClientImpl(String url) {
        this.url = url;
        if (!this.url.endsWith("/")) {
            this.url = String.valueOf(this.url) + "/";
        }
        this.servicePollerClient = new WSNPollerClient(url);
    }

    public String pollService(String wsdlURL, QName operation, Document inputMessage, String cronExpression, ServiceEndpoint replyTo, QName replyToOperation, QName topic) throws ServicePollerException {
        try {
            CronExpressionValidator.validateExpression((String)cronExpression);
        }
        catch (ParseException e1) {
            throw new ServicePollerException("Inivalid cronexpression", (Throwable)e1);
        }
        ServiceEndpoint se = new ServiceEndpoint();
        se.setEndpoint("HelloServicePort");
        se.setItf(QName.valueOf("{http://api.ws.dsb.petalslink.org/}HelloService"));
        se.setService(QName.valueOf("{http://api.ws.dsb.petalslink.org/}HelloServiceService"));
        ServicePollerInformation toPoll = new ServicePollerInformation();
        toPoll.setEndpointName(se.getEndpoint());
        toPoll.setInterfaceName(se.getItf());
        toPoll.setOperation(operation);
        toPoll.setServiceName(se.getService());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service to poll is : " + toPoll);
        }
        ServicePollerInformation reply = null;
        if (replyTo != null) {
            reply = new ServicePollerInformation();
            reply.setEndpointName(replyTo.getEndpoint());
            reply.setInterfaceName(replyTo.getItf());
            reply.setOperation(replyToOperation);
            reply.setServiceName(replyTo.getService());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service to reply to is : " + reply);
        }
        String result = null;
        try {
            result = this.servicePollerClient.start(toPoll, inputMessage, cronExpression, reply, topic);
        }
        catch (ServicePollerException e) {
            logger.log(Level.SEVERE, "Problem while starting the polling query...", e);
            throw new ServicePollerException("Problem while starting the polling query...", (Throwable)e);
        }
        return result;
    }

    public boolean stopPolling(String id) throws ServicePollerException {
        return this.servicePollerClient.stop(id);
    }

    private synchronized SOAPServiceBinder getSOAPBinderClient() {
        if (this.client == null) {
            this.client = (SOAPServiceBinder)CXFHelper.getClient((String)this.url, SOAPServiceBinder.class);
        }
        return this.client;
    }
}

