/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.io;

import java.io.IOException;
import java.io.InputStream;

public class InjectableInputStream
extends InputStream {
    private InputStream is;
    private boolean ended = false;

    public InjectableInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.is.read(b, off, len);
        if (!this.isEnded() && res == -1) {
            return 0;
        }
        return res;
    }

    public void endStream() {
        this.ended = true;
    }

    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        InputStream in = this.is;
        this.is = null;
        if (in != null) {
            in.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

