/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.utils;

import es.mityc.javasign.utils.ProvidersUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Utils {
    private static Log logger = LogFactory.getLog(Utils.class);

    public static byte[] getFileBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("El fichero indicado: " + file.getAbsolutePath() + " no existe.");
        }
        return Utils.getStreamBytes(new FileInputStream(file));
    }

    public static void writeFile(byte[] fileData, String fileName) throws IOException {
        File file = null;
        if (fileName != null) {
            file = new File(fileName);
        }
        Utils.writeFile(fileData, file);
    }

    public static void writeFile(byte[] fileData, File file) throws IOException {
        OutputStream os = null;
        if (fileData == null || fileData.length <= 0) {
            throw new IOException("Los datos a escribir son nulos o estan vac\u00edos");
        }
        os = file == null ? System.out : new FileOutputStream(file);
        if (os == null) {
            throw new IOException("No se pudo recuperar un handler para el fichero: " + file.getAbsolutePath());
        }
        os.write(fileData);
        os.close();
    }

    public static byte[] getStreamBytes(InputStream is) throws IOException {
        int BUF_SIZE = 512;
        ByteArrayOutputStream bos = null;
        int bytesRead = 0;
        byte[] data = null;
        data = new byte[512];
        bos = new ByteArrayOutputStream();
        while ((bytesRead = is.read(data, 0, 512)) >= 0) {
            bos.write(data, 0, bytesRead);
        }
        is.close();
        bos.close();
        return bos.toByteArray();
    }

    public static void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        BouncyCastleProvider p = new BouncyCastleProvider();
                        ProvidersUtil.registerProvider(p.getClass().getName());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Agregando el proveedor BC");
                        }
                        Integer res = Security.addProvider((Provider)p);
                        return res;
                    }
                    catch (Throwable e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Error al agregar el proveedor BC", e);
                        }
                        return null;
                    }
                }
            });
        }
    }
}

