/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.test;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.utils.WsstarCommonUtils;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.WsrfrlConstants;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.WsrfrpConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.AbsNotificationConsumerEngine;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NotificationConsumerService
extends AbsNotificationConsumerEngine {
    protected static final String RECEIVED_TERMINATION_NOTIFICATION = "receivedTerminationNotification";
    protected static final String RECEIVED_RP_VALUE_CHANGE_NOTIFICATION = "receivedRPValueChangeNotification";
    protected static final String RECEIVED_BUSINESS_LOGIC_NOTIFICATION = "receivedBusinessLogicNotification";
    private Map<String, Object> properties = null;
    private boolean isDebug = false;

    public NotificationConsumerService(Logger logger, Map<String, Object> properties, boolean isDebug) {
        super(logger);
        this.properties = properties;
        this.isDebug = isDebug;
    }

    public void notify(Notify request) {
        if (this.isDebug) {
            String msg = "\t[DEBUG - From consumer] Performs \"buisness code\" on receiving this \"Notify\" request...\n";
            this.logger.log(Level.FINE, msg);
            System.out.println(msg);
        }
        List msgs = request.getNotificationMessage();
        Element firstBusinessMsg = ((NotificationMessageHolderType)msgs.get(0)).getMessage().getAny();
        if (this.isDebug) {
            System.out.println("\t[DEBUG - From consumer] notification message details : \n" + WsstarCommonUtils.prettyPrint((Document)firstBusinessMsg.getOwnerDocument()));
        }
        if (firstBusinessMsg.getLocalName().contains(WsrfrlConstants.TERMINATION_NOTIFICATION_QNAME.getLocalPart()) && firstBusinessMsg.getNamespaceURI().equals(WsrfrlConstants.TERMINATION_NOTIFICATION_QNAME.getNamespaceURI())) {
            this.properties.put(RECEIVED_TERMINATION_NOTIFICATION, firstBusinessMsg);
        } else if (firstBusinessMsg.getLocalName().contains(WsrfrpConstants.RESOURCE_PROPERTY_VALUE_CHANGE_NOTIFICATION_QNAME.getLocalPart()) && firstBusinessMsg.getNamespaceURI().equals(WsrfrpConstants.RESOURCE_PROPERTY_VALUE_CHANGE_NOTIFICATION_QNAME.getNamespaceURI())) {
            this.properties.put(RECEIVED_RP_VALUE_CHANGE_NOTIFICATION, firstBusinessMsg);
        } else {
            this.properties.put(RECEIVED_BUSINESS_LOGIC_NOTIFICATION, firstBusinessMsg);
        }
    }
}

