/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.NotificationConsumerService;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.SubscriptionManagerService;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class NotificationProducerService
implements INotificationProducer,
INotificationProducerRP {
    private final String PETALS_NAMESPACE = "http://petals.ow2.org/petals-se-NotificationProducer";
    private final QName NOTIFICATION_PRODUCER_SERVICE_QNAME = new QName("http://petals.ow2.org/petals-se-NotificationProducer", "NotificationBrokerService");
    private final QName NOTIFICATION_PRODUCER_INTERFACE_QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "NotificationProducer");
    private final String NOTIFICATION_PRODUCER_ENDPOINT = "NotificationProducerServiceEndpoint";
    private NotificationProducerEngine notifProdEngine = null;
    private TopicsManagerEngine topicsMgrEngine = null;
    private SubscriptionManagerService subsMgrServ = null;
    private NotificationTransporter notifSender = null;

    public NotificationProducerService(Logger logger, InputStream supportedTopicsConfig, boolean isFixedTopicSet, TopicNamespaceType topicNSForRPChangeValueNotif, String nsPrefix, String mainPersistenceFolderName, NotificationConsumerService consumer) throws WsnbException {
        TopicSetType supportedTopics;
        this.notifSender = new NotificationTransporter(consumer);
        this.topicsMgrEngine = new TopicsManagerEngine();
        this.subsMgrServ = new SubscriptionManagerService(logger, mainPersistenceFolderName, this.notifSender);
        try {
            supportedTopics = Wsnb4ServUtils.getWstopReader().readTopicSetType(new InputSource(supportedTopicsConfig));
        }
        catch (WstopException e) {
            throw new WsnbException((Throwable)e);
        }
        this.notifProdEngine = new NotificationProducerEngine(logger, this.topicsMgrEngine, this.subsMgrServ.getSubsMgrEngine(), isFixedTopicSet, supportedTopics, topicNSForRPChangeValueNotif, nsPrefix, (ITransporterForWsnbPublisher)this.notifSender);
        this.notifProdEngine.setNotificationProducerEdp("NotificationProducerServiceEndpoint");
        this.notifProdEngine.setNotificationProducerInterface(this.NOTIFICATION_PRODUCER_INTERFACE_QNAME);
        this.notifProdEngine.setNotificationProducerService(this.NOTIFICATION_PRODUCER_SERVICE_QNAME);
    }

    public void restorePreviousState() throws AbsWSStarFault, WsnbException {
        Document supportedTopicsAsDOM;
        try {
            supportedTopicsAsDOM = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(this.notifProdEngine.getActorAsRP().getTopicSet());
        }
        catch (WstopException e) {
            throw new WsnbException((Throwable)e);
        }
        this.subsMgrServ.restorePreviousState(this.topicsMgrEngine, supportedTopicsAsDOM);
    }

    public TopicsManagerEngine getWstopTopicsMgr() {
        return this.topicsMgrEngine;
    }

    public SubscriptionManagerService getSubscriptionManagerService() {
        return this.subsMgrServ;
    }

    public QName getSUBSCRIPTION_MANAGER_SERVICE_QNAME() {
        return this.subsMgrServ.getSUBSCRIPTION_MANAGER_SERVICE_QNAME();
    }

    public QName getNOTIFICATION_PRODUCER_INTERFACE_QNAME() {
        return this.NOTIFICATION_PRODUCER_INTERFACE_QNAME;
    }

    public String getSUBSCRIPTION_MANAGER_SERVICE_EDP() {
        return this.subsMgrServ.getSUBSCRIPTION_MANAGER_ENDPOINT();
    }

    public SubscribeResponse subscribe(Subscribe payload) throws WsnbException, AbsWSStarFault {
        return this.notifProdEngine.subscribe(payload);
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage payload) throws WsnbException, AbsWSStarFault {
        return this.notifProdEngine.getCurrentMessage(payload);
    }

    public void setCurrentNotifyMessage(TopicExpressionType topic, NotificationMessageHolderType.Message notification, boolean isSameNotifyRequest) throws WsnbException, AbsWSStarFault {
        this.notifProdEngine.setCurrentMessage(topic, notification, isSameNotifyRequest);
    }

    public GetResourcePropertyResponse getResourceProperty(QName property) throws WsnbException, AbsWSStarFault {
        return this.notifProdEngine.getResourceProperty(property);
    }

    public UpdateResourcePropertiesResponse updateResourceProperties(UpdateResourceProperties request) throws WsnbException, AbsWSStarFault {
        return this.notifProdEngine.updateResourceProperties(request);
    }

    public void notifyNewSituation(Notify payloadToUse) throws WsnbException, AbsWSStarFault {
        List knownSubscriptions = this.subsMgrServ.getSubsMgrEngine().getStoredSubscriptionUuids();
        List notifications = payloadToUse.getNotificationMessage();
        for (NotificationMessageHolderType notificationItem : notifications) {
            this.setCurrentNotifyMessage(notificationItem.getTopic(), notificationItem.getMessage(), false);
        }
        if (!knownSubscriptions.isEmpty()) {
            this.notifSender.sendNotifyRequest(null, payloadToUse);
        }
    }

    private class NotificationTransporter
    implements ITransporterForWsnbPublisher {
        private NotificationConsumerService consumer = null;

        public NotificationTransporter(NotificationConsumerService consumer) {
            this.consumer = consumer;
        }

        public void sendNotifyRequest(EndpointReferenceType consumerServiceEdp, Notify payload) {
            this.consumer.notify(payload);
        }
    }
}

