/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsaddressing10.api.type.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.persistence.WsnbPersistence;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.io.File;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class SubscriptionManagerService {
    private final String PETALS_NAMESPACE = "http://petals.ow2.org/petals-se-SubscriptionManager";
    private final String persistedSubscriptionFolderName = "SaveSubscriptionManagerRP" + File.separatorChar;
    private final QName SUBSCRIPTION_MANAGER_SERVICE_QNAME = new QName("http://petals.ow2.org/petals-se-SubscriptionManager", "SubscriptionManagerService");
    private final QName SUBSCRIPTION_MANAGER_INTERFACE_QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "SubscriptionManager");
    private final String SUBSCRIPTION_MANAGER_ENDPOINT = "SubscriptionManagerServiceEndpoint";
    private WsnbPersistence persistenceMgr = null;
    private SubscriptionManagerEngine subsMgrEngine = null;

    public SubscriptionManagerService(Logger logger, String mainPersistenceFolderName, ITransporterForWsnbPublisher notificationSender) throws WsnbException {
        this.persistenceMgr = new WsnbPersistence(new File(mainPersistenceFolderName + File.separatorChar + this.persistedSubscriptionFolderName));
        this.subsMgrEngine = new SubscriptionManagerEngine(logger, this.persistenceMgr, notificationSender);
        this.subsMgrEngine.setSubscriptionsManagerEdp("SubscriptionManagerServiceEndpoint");
        this.subsMgrEngine.setSubscriptionsManagerInterface(this.SUBSCRIPTION_MANAGER_INTERFACE_QNAME);
        this.subsMgrEngine.setSubscriptionsManagerService(this.SUBSCRIPTION_MANAGER_SERVICE_QNAME);
    }

    public void restorePreviousState(TopicsManagerEngine topicsMgr, Document supportedTopicsAsDOM) throws AbsWSStarFault, WsnbException {
        this.subsMgrEngine.restorePersistedSubscriptions(topicsMgr, supportedTopicsAsDOM);
    }

    public SubscriptionManagerEngine getSubsMgrEngine() {
        return this.subsMgrEngine;
    }

    public QName getSUBSCRIPTION_MANAGER_SERVICE_QNAME() {
        return this.SUBSCRIPTION_MANAGER_SERVICE_QNAME;
    }

    public QName getSUBSCRIPTION_MANAGER_INTERFACE_QNAME() {
        return this.SUBSCRIPTION_MANAGER_INTERFACE_QNAME;
    }

    public String getSUBSCRIPTION_MANAGER_ENDPOINT() {
        return "SubscriptionManagerServiceEndpoint";
    }

    public UnsubscribeResponse unsubscribe(EndpointReferenceType subscriptionRef, Unsubscribe payload) throws WsnbException, AbsWSStarFault {
        String targetSubscriptionUuid = Wsnb4ServUtils.getSubscriptionIdFromReferenceParams((ReferenceParametersType)subscriptionRef.getReferenceParameters());
        this.subsMgrEngine.setTargetSubscriptionResourceUuid(targetSubscriptionUuid);
        return this.subsMgrEngine.unsubscribe(payload);
    }

    public RenewResponse renew(EndpointReferenceType subscriptionRef, Renew payload) throws WsnbException, AbsWSStarFault {
        String targetSubscriptionUuid = Wsnb4ServUtils.getSubscriptionIdFromReferenceParams((ReferenceParametersType)subscriptionRef.getReferenceParameters());
        this.subsMgrEngine.setTargetSubscriptionResourceUuid(targetSubscriptionUuid);
        return this.subsMgrEngine.renew(payload);
    }
}

