/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.EndpointReference;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsaddressing10.api.type.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WSNUtil;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseSubscription;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseSubscriptionResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeSubscription;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeSubscriptionResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.WsrfrpConstants;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.NotificationConsumerService;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.NotificationProducerService;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.SubscriptionManagerService;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.test.WsnbServiceUnitTestUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbRequestor;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbSubscriber;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TestBaseNotificationServicesTest
extends TestCase {
    private final String MAIN_PERSISTENCE_FOLDER = "tmp_for_persistence";
    private final String TEST_NAME = "testName";
    private final String SUBS_REQUEST_AS_OBJ = "subsRequestAsObj";
    private final String SUBS_RESPONSE_AS_OBJ = "subsResponseAsObj";
    private final String CURRENT_MESSAGE_RESP = "getCurrentMessageResponse";
    private final String RENEW_REQUEST_AS_OBJ = "renewRequestAsObj";
    private final String RENEW_RESPONSE_AS_OBJ = "renewResponseAsObj";
    private final String WSNFAULT_EXPECTED = "wsnFaultExpected";
    private final String MUST_BE_STORED = "mustBeStored";
    private NotificationProducerService wsnbProducerService;
    private SubscriptionManagerService wsnbSubscriptionMgrService;
    private NotificationConsumerService wsnbConsumerService;
    private RequestorActor requestor;
    private Map<String, Object> properties = null;
    boolean isPassed = false;
    boolean isDebug = false;

    protected void setUp() throws Exception {
        super.setUp();
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }

    protected void initUnitTest(String testName) throws Exception {
        this.properties = new HashMap<String, Object>();
        this.isPassed = false;
        this.properties.put("testName", testName);
        System.out.println("\n =============================================== \n\t \n\t ---> Start unit test named : " + testName + "...\n" + "\n\t ... Init BaseNotification services ...");
        InputStream supportedTopicsConfig = TestBaseNotificationServicesTest.class.getResourceAsStream("/models/SupportedTopicsSet.xml");
        this.wsnbConsumerService = new NotificationConsumerService(Logger.getLogger("TestBaseNotificationServices "), this.properties, this.isDebug);
        String nsPrefix = "wsn-prod";
        TopicNamespaceType topicNS = RefinedWstopFactory.getInstance().createTopicNamespaceType(new URI("http://com.ebmwebsourcing.com/wsn/producer-sample"));
        topicNS.setFinal(true);
        topicNS.setName("WsnProducerTopicNamespace");
        TopicNamespaceType.Topic topicForTopicSetChange = RefinedWstopFactory.getInstance().createTopicNamespaceTypeTopic("TopicSet");
        topicForTopicSetChange.setFinal(true);
        topicForTopicSetChange.addMessageType(WsrfrpConstants.RESOURCE_PROPERTY_VALUE_CHANGE_NOTIFICATION_QNAME);
        topicNS.addTopic(topicForTopicSetChange);
        this.wsnbProducerService = new NotificationProducerService(Logger.getLogger("TestBaseNotificationServices "), supportedTopicsConfig, false, topicNS, nsPrefix, "tmp_for_persistence", this.wsnbConsumerService);
        this.wsnbSubscriptionMgrService = this.wsnbProducerService.getSubscriptionManagerService();
        this.requestor = new RequestorActor(this.wsnbProducerService, this.wsnbSubscriptionMgrService);
    }

    protected void endUnitTest() throws Exception {
        String resultMessage = "\n\t ---> ...test " + this.properties.get("testName") + " result : ";
        resultMessage = resultMessage + (this.isPassed ? "SUCCESS" : "FAILED") + " !! \n\n ========================================== \n\t";
        System.out.println(resultMessage);
        Assert.assertTrue((boolean)this.isPassed);
    }

    private boolean removeTmpTestFolder() {
        File[] subFolders;
        File main = new File("tmp_for_persistence");
        for (File subFolderItem : subFolders = main.listFiles()) {
            if (subFolderItem == null) continue;
            File[] Files = subFolderItem.listFiles();
            if (Files != null) {
                for (File fileItem : Files) {
                    fileItem.delete();
                }
            }
            subFolderItem.delete();
        }
        return !main.exists() || main.delete();
    }

    private void performSubscribeRequest(String payloadXmlFile) throws AbsWSStarFault, WsnbException {
        SubscribeResponse response = null;
        String testName = (String)this.properties.get("testName");
        Document requestAsDoc = WsnbServiceUnitTestUtils.fromStreamToDocument(TestBaseNotificationServicesTest.class.getResourceAsStream(payloadXmlFile));
        Assert.assertNotNull((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause : Error on \"Susbcribe\" xml file payload of access"), (Object)requestAsDoc);
        Subscribe requestAsWsnType = Wsnb4ServUtils.getWsnbReader().readSubscribe(requestAsDoc);
        this.properties.put("subsRequestAsObj", requestAsWsnType);
        try {
            response = this.requestor.sendSubscribeRequest(null, requestAsWsnType);
            this.properties.put("subsResponseAsObj", response);
        }
        catch (AbsWSStarFault wsnFault) {
            wsnFault.printStackTrace();
            if (((Boolean)this.properties.get("wsnFaultExpected")).booleanValue()) {
                throw wsnFault;
            }
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause : Unexpected WSNotificationFault Returned"), (boolean)false);
        }
        Assert.assertNotNull((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Subscribe\" request's response is null !"), (Object)response);
        Assert.assertTrue((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Subscribe \" request's response has wrong type.\n" + "Expected type is \"SubscribeResponse\" Type !"), (boolean)(response instanceof SubscribeResponse));
    }

    private void performUnsubscribeRequest() throws WsnbException, AbsWSStarFault {
        UnsubscribeResponse response = null;
        String testName = (String)this.properties.get("testName");
        SubscribeResponse respSubs = (SubscribeResponse)this.properties.get("subsResponseAsObj");
        EndpointReferenceType subscriptionRef = respSubs.getSubscriptionReference();
        Unsubscribe requestUnsubscribe = RefinedWsnbFactory.getInstance().createUnsubscribe();
        Assert.assertNotNull((Object)requestUnsubscribe);
        try {
            response = this.requestor.sendUnsubscribeRequest(subscriptionRef, requestUnsubscribe);
        }
        catch (AbsWSStarFault wsnFault) {
            if (((Boolean)this.properties.get("wsnFaultExpected")).booleanValue()) {
                throw wsnFault;
            }
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause : Unexpected WSNotificationFault Returned"), (boolean)false);
        }
        Assert.assertNotNull((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Unsubscribe\" request's response is null !"), (Object)response);
        Assert.assertTrue((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Unsubscribe\" request's response has wrong type.\n" + "Expected type is \"UnsubscribeResponse\" Type !"), (boolean)(response instanceof UnsubscribeResponse));
    }

    private void performNotifyRequest(String payloadXmlFile) throws WsnbException, AbsWSStarFault {
        Document request = WsnbServiceUnitTestUtils.fromStreamToDocument(TestBaseNotificationServicesTest.class.getResourceAsStream("/models/Notify.xml"));
        Assert.assertNotNull((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause : Error on Subscribe.xml file access"), (Object)request);
        Notify reqObj = Wsnb4ServUtils.getWsnbReader().readNotify(request);
        this.wsnbProducerService.notifyNewSituation(reqObj);
    }

    private void performGetCurrentMessageRequest(String payloadXmlFile) throws WsnbException, AbsWSStarFault {
        GetCurrentMessageResponse response = null;
        String testName = (String)this.properties.get("testName");
        Document request = WsnbServiceUnitTestUtils.fromStreamToDocument(TestBaseNotificationServicesTest.class.getResourceAsStream(payloadXmlFile));
        Assert.assertNotNull((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause : Error on GetCurrentMessage.xml file access"), (Object)request);
        GetCurrentMessage getCurMsgObj = Wsnb4ServUtils.getWsnbReader().readGetCurrentMessage(request);
        try {
            response = this.requestor.sendGetCurrentMessageRequest(null, getCurMsgObj);
            this.properties.put("getCurrentMessageResponse", response);
        }
        catch (AbsWSStarFault wsnFault) {
            if (((Boolean)this.properties.get("wsnFaultExpected")).booleanValue()) {
                throw wsnFault;
            }
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause : Unexpected WSNotificationFault Returned"), (boolean)false);
        }
        Assert.assertNotNull((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"GetCurrentMessage\" request's response is null !"), (Object)response);
        Assert.assertTrue((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"GetCurrentMessage\" request's response has wrong type.\n" + "Expected type is \"GetCurrentMessageResponse\" Type !(received : " + response.getClass().getSimpleName() + ")"), (boolean)(response instanceof GetCurrentMessageResponse));
    }

    private void performRenewRequest(String payloadXmlFile) throws AbsWSStarFault, WsnbException {
        RenewResponse response = null;
        String testName = (String)this.properties.get("testName");
        Document requestAsDoc = WsnbServiceUnitTestUtils.fromStreamToDocument(TestBaseNotificationServicesTest.class.getResourceAsStream(payloadXmlFile));
        Assert.assertNotNull((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause : Error on Renew.xml file access"), (Object)requestAsDoc);
        Renew requestAsWsnType = Wsnb4ServUtils.getWsnbReader().readRenew(requestAsDoc);
        this.properties.put("renewRequestAsObj", requestAsWsnType);
        EndpointReferenceType susbcriptionRef = ((SubscribeResponse)this.properties.get("subsResponseAsObj")).getSubscriptionReference();
        try {
            response = this.requestor.sendRenewRequest(susbcriptionRef, requestAsWsnType);
            this.properties.put("renewResponseAsObj", response);
        }
        catch (AbsWSStarFault wsnFault) {
            if (((Boolean)this.properties.get("wsnFaultExpected")).booleanValue()) {
                throw wsnFault;
            }
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause : Unexpected WSNotificationFault Returned"), (boolean)false);
        }
        Assert.assertNotNull((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Renew\" request's response is null !"), (Object)response);
        Assert.assertTrue((String)("Unit test named : \"" + testName + "\" failed !\n Cause :  \"Renew \" request's response has wrong type.\n" + "Expected type is \"RenewResponse\" Type !"), (boolean)(response instanceof RenewResponse));
    }

    private boolean checkSubscriptionUuidStorage() throws WsnbException, AbsWSStarFault {
        boolean result = false;
        SubscribeResponse reqRespObj = (SubscribeResponse)this.properties.get("subsResponseAsObj");
        String subscriptionUuid = Wsnb4ServUtils.getSubscriptionIdFromReferenceParams((ReferenceParametersType)reqRespObj.getSubscriptionReference().getReferenceParameters());
        ArrayList subscriptionIdsList = new ArrayList();
        subscriptionIdsList.addAll(this.wsnbSubscriptionMgrService.getSubsMgrEngine().getStoredSubscriptionUuids());
        if (((Boolean)this.properties.get("mustBeStored")).booleanValue()) {
            Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "SubscriptionUuid \"" + subscriptionUuid + "\" not stored in Supported topic set tree"), (boolean)subscriptionIdsList.contains(subscriptionUuid));
        } else {
            Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "SubscriptionUuid \"" + subscriptionUuid + "\" not removed from Supported topic set tree"), (!subscriptionIdsList.contains(subscriptionUuid) ? 1 : 0) != 0);
        }
        result = true;
        return result;
    }

    private boolean checkReceivedNotification(boolean isRPValChangeNotifExpected, boolean isTerminationNotifExpected) {
        boolean result = false;
        Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "\"ResourcePropertyValueChangeNotification\" Notify requests not received (then stored) by the consumer "), (!isRPValChangeNotifExpected || this.properties.get("receivedRPValueChangeNotification") != null ? 1 : 0) != 0);
        if (((Boolean)this.properties.get("mustBeStored")).booleanValue()) {
            Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "Notify requests not received (then stored) by the consumer "), (this.properties.get("receivedBusinessLogicNotification") != null ? 1 : 0) != 0);
        }
        result = true;
        return result;
    }

    private boolean checkGetCurrentMessageStorage() {
        boolean result = false;
        if (((Boolean)this.properties.get("mustBeStored")).booleanValue()) {
            Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "No Notification Message stored on given topic !"), (((GetCurrentMessageResponse)this.properties.get("getCurrentMessageResponse")).getNotifications().size() > 0 ? 1 : 0) != 0);
        }
        result = true;
        return result;
    }

    private boolean checkRenew() {
        boolean result = false;
        SubscribeResponse subsResp = (SubscribeResponse)this.properties.get("subsResponseAsObj");
        RenewResponse renewResp = (RenewResponse)this.properties.get("renewResponseAsObj");
        if (((Boolean)this.properties.get("mustBeStored")).booleanValue()) {
            Assert.assertTrue((String)("\nUnit test named : \"" + this.properties.get("testName") + "\" failed !\n Cause :  " + "No modification on Subscription TerminationTimeStamp !"), (boolean)subsResp.getTerminationTime().before(renewResp.getTerminationTime()));
        }
        result = true;
        return result;
    }

    @Test
    public void testSubscribeRequest() throws Exception {
        String testName = "Simple \"Subscribe\" request";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performSubscribeRequest("/models/Subscribe.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed = this.checkSubscriptionUuidStorage();
        this.endUnitTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscribeRequestOnBadTopic() throws Exception {
        String testName = "\"Subscribe\" request on Unknown topic";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(true));
        try {
            this.performSubscribeRequest("/models/SubscribeOnBadTopic.xml");
        }
        catch (AbsWSStarFault wsnFault) {
            this.isPassed = wsnFault instanceof TopicNotSupportedFault;
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause :  Bad WSNotificationFault type received. Expected \"TopicNotSupportedFault\" type"), (boolean)this.isPassed);
            if (this.isDebug) {
                Document faultAsDoc = wsnFault.getDocumentFragment();
                System.out.println("[DEBUG ] wsnFaultAsDocument: \n\n" + Wsnb4ServUtils.prettyPrint((Document)faultAsDoc) + "\n\n");
            }
        }
        finally {
            this.endUnitTest();
        }
    }

    @Test
    public void testUnsubscribeToExistingSubscriptionRequest() throws Exception {
        String testName = "\"Unsubscribe\" request to existing subscription";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performSubscribeRequest("/models/Subscribe.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed = this.checkSubscriptionUuidStorage();
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performUnsubscribeRequest();
        this.properties.put("mustBeStored", new Boolean(false));
        this.isPassed &= this.checkSubscriptionUuidStorage();
        this.endUnitTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsubscribeToUnknownSubscriptionRequest() throws Exception {
        String testName = "\"Unsubscribe \" request on unknown subscription";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(true));
        try {
            URI address = new URI(this.wsnbProducerService.getSUBSCRIPTION_MANAGER_SERVICE_QNAME().getNamespaceURI() + ":" + this.wsnbProducerService.getSUBSCRIPTION_MANAGER_SERVICE_QNAME().getLocalPart() + "@" + this.wsnbProducerService.getSUBSCRIPTION_MANAGER_SERVICE_EDP());
            EndpointReferenceType subscriptionRef = (EndpointReferenceType)WSNUtil.getInstance().getXmlObjectFactory().create(EndpointReference.class);
            Address addr = (Address)WSNUtil.getInstance().getXmlObjectFactory().create(Address.class);
            addr.setValue(address);
            subscriptionRef.setAddress(addr);
            Element subscriptionUuidAsElt = Wsnb4ServUtils.createSubscriptionIdAsReferenceParamElt((String)UUID.randomUUID().toString());
            ReferenceParameters refParams = (ReferenceParameters)WSNUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
            refParams.addAny((Object)subscriptionUuidAsElt);
            subscriptionRef.setReferenceParameters(refParams);
            SubscribeResponse response = RefinedWsnbFactory.getInstance().createSubscribeResponse(subscriptionRef);
            this.properties.put("subsResponseAsObj", response);
            this.performUnsubscribeRequest();
        }
        catch (AbsWSStarFault wsnFault) {
            this.isPassed = wsnFault instanceof ResourceUnknownFault;
            Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause :  Bad WSNotificationFault type received. Expected \"ResourceUnknownFault\" type"), (boolean)this.isPassed);
        }
        finally {
            this.endUnitTest();
        }
    }

    @Test
    public void testNotifyRequest() throws Exception {
        String testName = "\"Notify\" request with existing consumer subscription";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performSubscribeRequest("/models/Subscribe.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed = this.checkSubscriptionUuidStorage();
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performNotifyRequest("/models/Notify.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed &= this.checkReceivedNotification(false, false);
        this.endUnitTest();
    }

    @Test
    public void testGetCurrentMessageRequest() throws Exception {
        String testName = "\"GetCurrentMessage \" request";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performNotifyRequest("/models/Notify.xml");
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performGetCurrentMessageRequest("/models/GetCurrentMessage.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed = this.checkGetCurrentMessageStorage();
        this.endUnitTest();
    }

    @Test
    public void testRenewRequest() throws Exception {
        String testName = "\"Renew\" request";
        this.initUnitTest(testName);
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performSubscribeRequest("/models/Subscribe.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed = this.checkSubscriptionUuidStorage();
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performRenewRequest("/models/Renew.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed &= this.checkRenew();
        this.endUnitTest();
    }

    @Test
    public void testExtensionOfSupportedTopic() throws Exception {
        block3: {
            String testName = "Addition of new supported topics during runtine";
            this.initUnitTest(testName);
            this.properties.put("wsnFaultExpected", new Boolean(true));
            try {
                this.performSubscribeRequest("/models/SubscribeOnTopicNotYetSupported.xml");
            }
            catch (AbsWSStarFault wsnFault) {
                this.isPassed = wsnFault instanceof TopicNotSupportedFault;
                Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause :  Bad WSNotificationFault type received. Expected \"TopicNotSupportedFault\" type"), (boolean)this.isPassed);
                if (!this.isDebug) break block3;
                Document faultAsDoc = wsnFault.getDocumentFragment();
                System.out.println("[DEBUG ] wsnFaultAsDocument: \n\n" + Wsnb4ServUtils.prettyPrint((Document)faultAsDoc) + "\n\n");
            }
        }
        InputStream newTopicSet = TestBaseNotificationServicesTest.class.getResourceAsStream("/models/UpdateToExtendTopicsSet.xml");
        TopicSetType newTopicSetRP = Wsnb4ServUtils.getWstopReader().readTopicSetType(new InputSource(newTopicSet));
        Document topicSetAsDOM = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(newTopicSetRP);
        ArrayList<Element> properties = new ArrayList<Element>();
        properties.add(topicSetAsDOM.getDocumentElement());
        UpdateType content = RefinedWsrfrpFactory.getInstance().createUpdateType(properties);
        UpdateResourceProperties request = RefinedWsrfrpFactory.getInstance().createUpdateResourceProperties(content);
        UpdateResourcePropertiesResponse response = this.wsnbProducerService.updateResourceProperties(request);
        if (response != null) {
            Document doc = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeUpdateResourcePropertiesResponseAsDOM(response);
            System.out.println("doc = \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            GetResourcePropertyResponse resp = this.wsnbProducerService.getResourceProperty(WstopConstants.TOPIC_SET_QNAME);
            Document doc2 = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeGetResourcePropertyResponseAsDOM(resp);
            System.out.println("doc2 = \n" + XMLPrettyPrinter.prettyPrint((Document)doc2));
            System.out.println("\n\t ---> [Intermediate result] \"TopicSet\" resourceProperty updated !");
        }
        this.properties.put("wsnFaultExpected", new Boolean(false));
        this.performSubscribeRequest("/models/SubscribeOnTopicNotYetSupported.xml");
        this.properties.put("mustBeStored", new Boolean(true));
        this.isPassed &= this.checkSubscriptionUuidStorage();
        this.endUnitTest();
    }

    @Test
    public void testReductionOfSupportedTopicWithoutTerminationNotif() throws Exception {
        String testName = "Suppression of some existing supported topics whitout subscription destruction during runtine";
        this.reductionOfSupportedTopicWithNotif(testName, "/models/Subscribe.xml", false);
    }

    private void reductionOfSupportedTopicWithNotif(String testName, String subscribeRequestPath, boolean isTerminationNotificationExpected) throws Exception {
        block3: {
            this.initUnitTest(testName);
            this.properties.put("wsnFaultExpected", new Boolean(false));
            this.performSubscribeRequest(subscribeRequestPath);
            this.properties.put("mustBeStored", new Boolean(true));
            this.isPassed = this.checkSubscriptionUuidStorage();
            InputStream newTopicSet = TestBaseNotificationServicesTest.class.getResourceAsStream("/models/UpdateToReduceTopicsSet.xml");
            TopicSetType newTopicSetRP = Wsnb4ServUtils.getWstopReader().readTopicSetType(new InputSource(newTopicSet));
            Document topicSetAsDOM = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(newTopicSetRP);
            ArrayList<Element> properties = new ArrayList<Element>();
            properties.add(topicSetAsDOM.getDocumentElement());
            UpdateType content = RefinedWsrfrpFactory.getInstance().createUpdateType(properties);
            UpdateResourceProperties request = RefinedWsrfrpFactory.getInstance().createUpdateResourceProperties(content);
            UpdateResourcePropertiesResponse response = this.wsnbProducerService.updateResourceProperties(request);
            if (response != null) {
                System.out.println("\n\t ---> [Intermediate result] \"TopicSet\" resourceProperty updated !");
            }
            this.properties.put("mustBeStored", new Boolean(false));
            this.isPassed &= this.checkReceivedNotification(true, isTerminationNotificationExpected);
            this.properties.put("wsnFaultExpected", new Boolean(true));
            try {
                this.performSubscribeRequest("/models/SubscribeOnTopicToBeRemoved.xml");
            }
            catch (AbsWSStarFault wsnFault) {
                this.isPassed &= wsnFault instanceof TopicNotSupportedFault;
                Assert.assertTrue((String)("\nUnit test named : \"" + testName + "\" failed !\n Cause :  Bad WSNotificationFault type received. Expected \"TopicNotSupportedFault\" type"), (boolean)this.isPassed);
                if (!this.isDebug) break block3;
                Document faultAsDoc = wsnFault.getDocumentFragment();
                System.out.println("[DEBUG ] wsnFaultAsDocument: \n\n" + Wsnb4ServUtils.prettyPrint((Document)faultAsDoc) + "\n\n");
            }
        }
        this.properties.put("mustBeStored", new Boolean(!isTerminationNotificationExpected));
        this.isPassed &= this.checkSubscriptionUuidStorage();
        this.endUnitTest();
    }

    private class RequestorActor
    implements ITransporterForWsnbSubscriber,
    ITransporterForWsnbRequestor {
        private NotificationProducerService wnsbProducer = null;
        private SubscriptionManagerService wnsbSubscriptionManager = null;

        public RequestorActor(NotificationProducerService producer, SubscriptionManagerService subscriptionMgr) {
            this.wnsbProducer = producer;
            this.wnsbSubscriptionManager = subscriptionMgr;
        }

        public SubscribeResponse sendSubscribeRequest(EndpointReferenceType knownProducerEdp, Subscribe payload) throws AbsWSStarFault {
            SubscribeResponse response = null;
            try {
                response = this.wnsbProducer.subscribe(payload);
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            return response;
        }

        public UnsubscribeResponse sendUnsubscribeRequest(EndpointReferenceType subscriptionMgrEdp, Unsubscribe payload) throws AbsWSStarFault {
            UnsubscribeResponse response = null;
            try {
                response = this.wnsbSubscriptionManager.unsubscribe(subscriptionMgrEdp, payload);
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            return response;
        }

        public RenewResponse sendRenewRequest(EndpointReferenceType subscriptionMgrEdp, Renew payload) throws AbsWSStarFault {
            RenewResponse response = null;
            try {
                response = this.wnsbSubscriptionManager.renew(subscriptionMgrEdp, payload);
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            return response;
        }

        public PauseSubscriptionResponse sendPauseSubscriptionRequest(EndpointReferenceType subscriptionMgrEdp, PauseSubscription payload) throws AbsWSStarFault {
            return null;
        }

        public ResumeSubscriptionResponse sendResumeSubscriptionRequest(EndpointReferenceType subscriptionMgrEdp, ResumeSubscription payload) throws AbsWSStarFault {
            return null;
        }

        public GetCurrentMessageResponse sendGetCurrentMessageRequest(EndpointReferenceType knownProducerEdp, GetCurrentMessage payload) throws AbsWSStarFault {
            GetCurrentMessageResponse response = null;
            try {
                response = this.wnsbProducer.getCurrentMessage(payload);
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            return response;
        }
    }
}

