/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.engines;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsn.t_1_extension.EJaxbConcreteTopicExpressionWithQName;
import com.ebmwebsourcing.wsn.t_1_extension.ObjectFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationProducerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyChangeFailureType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyValueChangeNotificationType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopDatatypeUtils;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NoCurrentMessageOnTopicFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WsnbTopicManagerBadUsageException;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfrp.services.faults.InvalidResourcePropertyQNameFault;
import com.ebmwebsourcing.wsstar.wsrfrp.services.faults.UnableToModifyResourcePropertyFault;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NotificationProducerEngine
implements INotificationProducer,
INotificationProducerRP {
    protected Logger logger;
    protected String wsnProducerEndpoint = "";
    protected QName wsnProducerService = null;
    protected QName wsnProducerInterface = null;
    protected NotificationProducerRP actorAsRP = null;
    protected TopicNamespaceType topicNSForRPChangeValueNotif = null;
    protected String associatedNSPrefix = null;
    protected TopicsManagerEngine topicsManager;
    protected SubscriptionManagerEngine subscriptionManagerService;
    protected Map<QName, List<NotificationMessageHolderType.Message>> currentMessages = null;
    protected ITransporterForWsnbPublisher notificationSender = null;
    protected ObjectFactory factory = new ObjectFactory();

    public NotificationProducerEngine(Logger logger, TopicsManagerEngine topicsMgr, SubscriptionManagerEngine subsMgr, boolean isFixedTopicSet, TopicSetType supportedTopics, TopicNamespaceType topicNSForRPChangeNotif, String prefixForNs, ITransporterForWsnbPublisher transporter) throws WsnbException {
        this.logger = logger;
        this.topicsManager = topicsMgr;
        this.subscriptionManagerService = subsMgr;
        this.topicNSForRPChangeValueNotif = topicNSForRPChangeNotif;
        this.associatedNSPrefix = prefixForNs;
        this.notificationSender = transporter;
        this.initActorAsRPAndAttributes(isFixedTopicSet, supportedTopics);
    }

    public NotificationProducerEngine(Logger logger, SubscriptionManagerEngine subsMgr, boolean isFixedTopicSet, TopicSetType supportedTopics, TopicNamespaceType topicNSForRPChangeNotif, String prefixForNs, ITransporterForWsnbPublisher transporter) throws WsnbException {
        this.logger = logger;
        this.subscriptionManagerService = subsMgr;
        this.topicNSForRPChangeValueNotif = topicNSForRPChangeNotif;
        this.associatedNSPrefix = prefixForNs;
        this.notificationSender = transporter;
        this.initActorAsRPAndAttributes(isFixedTopicSet, supportedTopics);
    }

    public NotificationProducerEngine(boolean isFixedTopicSet, TopicSetType supportedTopics, TopicNamespaceType topicNSForRPChangeNotif, String prefixForNs, ITransporterForWsnbPublisher transporter) throws WsnbException {
        this.topicNSForRPChangeValueNotif = topicNSForRPChangeNotif;
        this.associatedNSPrefix = prefixForNs;
        this.notificationSender = transporter;
        this.initActorAsRPAndAttributes(isFixedTopicSet, supportedTopics);
    }

    protected void initActorAsRPAndAttributes(boolean isFixedTopicSet, TopicSetType supportedTopics) throws WsnbException {
        this.actorAsRP = RefinedWsnbFactory.getInstance().createNotificationProducerRP();
        this.actorAsRP.setFixedTopicSet(Boolean.valueOf(isFixedTopicSet));
        TopicSetType mergedTopicSet = supportedTopics;
        if (!isFixedTopicSet) {
            try {
                mergedTopicSet = WstopDatatypeUtils.addTopicsFromTopicNamespaceToTopicSet((TopicSetType)supportedTopics, (TopicNamespaceType)this.topicNSForRPChangeValueNotif, (String)this.associatedNSPrefix);
            }
            catch (WstopException e) {
                throw new WsnbException((Throwable)e);
            }
        }
        try {
            Document topicSetDom = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(mergedTopicSet);
        }
        catch (WstopException e) {
            e.printStackTrace();
        }
        this.actorAsRP.setTopicSet(mergedTopicSet);
        this.currentMessages = new ConcurrentHashMap<QName, List<NotificationMessageHolderType.Message>>();
    }

    public void setNotificationProducerEdp(String notificationProducerEdp) {
        this.wsnProducerEndpoint = notificationProducerEdp;
    }

    public String getNotificationProducerEdp() {
        return this.wsnProducerEndpoint;
    }

    public void setNotificationProducerService(QName notificationProducerService) {
        this.wsnProducerService = notificationProducerService;
    }

    public QName getNotificationProducerService() {
        return this.wsnProducerService;
    }

    public void setNotificationProducerInterface(QName notificationProducerInterface) {
        this.wsnProducerInterface = notificationProducerInterface;
    }

    public QName getNotificationProducerInterfaceQName() {
        return this.wsnProducerInterface != null ? this.wsnProducerInterface : WsnbConstants.NOTIFICATION_PRODUCER_INTERFACE;
    }

    public NotificationProducerRP getActorAsRP() {
        return this.actorAsRP;
    }

    public TopicsManagerEngine getTopicsMgr() {
        return this.topicsManager;
    }

    public void setTopicsMgr(TopicsManagerEngine topicsMgr) {
        this.topicsManager = topicsMgr;
    }

    public SubscriptionManagerEngine getSubsMgr() {
        return this.subscriptionManagerService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"GetCurrentMessage\" request ...");
        if (this.topicsManager == null) {
            throw new WsnbTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        GetCurrentMessageResponse response = null;
        TopicExpressionType topic = request.getTopic();
        QName concreteTopicKey = null;
        if (topic.getContent() instanceof JAXBElement) {
            JAXBElement elmt = (JAXBElement)topic.getContent();
            if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type not supported here");
            concreteTopicKey = (QName)elmt.getValue();
        } else {
            if (!(topic.getContent() instanceof EJaxbConcreteTopicExpressionWithQName)) throw new WsnbException("TopicExpression type not supported here");
            EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)topic.getContent();
            concreteTopicKey = new QName(msgTopic.getConcreteTopicExpression());
        }
        List<NotificationMessageHolderType.Message> notifs = this.currentMessages.get(concreteTopicKey);
        if (notifs != null && notifs.size() > 0) {
            response = RefinedWsnbFactory.getInstance().createGetCurrentMessageResponse(notifs.get(0));
            for (int i = 1; i < notifs.size(); ++i) {
                response.addCurrentMessage(notifs.get(i));
            }
            return response;
        } else {
            try {
                throw new NoCurrentMessageOnTopicFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The topic referenced in the GetCurrentMessage message does not have any pending messages.");
            }
            catch (WsrfbfException e) {
                throw new WsnbException((Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCurrentMessage(TopicExpressionType topic, NotificationMessageHolderType.Message notification, boolean isSameNotifyRequest) throws WsnbException, AbsWSStarFault {
        QName currentMessageKey = null;
        if (topic.getContent() instanceof JAXBElement) {
            JAXBElement elmt = (JAXBElement)topic.getContent();
            if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type not supported here");
            currentMessageKey = (QName)elmt.getValue();
        } else {
            if (!(topic.getContent() instanceof EJaxbConcreteTopicExpressionWithQName)) throw new WsnbException("TopicExpression type not supported here");
            EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)topic.getContent();
            currentMessageKey = new QName(msgTopic.getConcreteTopicExpression());
        }
        List<NotificationMessageHolderType.Message> lastNotifications = this.currentMessages.get(currentMessageKey);
        if (lastNotifications == null) {
            lastNotifications = new ArrayList<NotificationMessageHolderType.Message>();
            this.currentMessages.put(currentMessageKey, lastNotifications);
        } else if (!isSameNotifyRequest) {
            lastNotifications.clear();
        }
        lastNotifications.add(notification);
    }

    public SubscribeResponse subscribe(Subscribe request) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Subscribe\" request ...");
        if (this.topicsManager == null) {
            throw new WsnbTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        SubscribeResponse reponse = null;
        List topics = request.getFilter().getTopicExpressions();
        try {
            String subscriptionId = UUID.randomUUID().toString();
            ArrayList<TopicExpressionType> concreteTopics = new ArrayList<TopicExpressionType>();
            Document supportedTopicsAsDOM = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(this.actorAsRP.getTopicSet());
            for (TopicExpressionType topExprItem : topics) {
                List<TopicExpressionType> foundTopics = this.topicsManager.getTopicsAsConcreteTopExpr(topExprItem, supportedTopicsAsDOM);
                if (foundTopics.isEmpty()) {
                    throw new TopicNotSupportedFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The Subscribe message contained a TopicExpression filter that referenced a topic that was not supported by the NotificationProducer.");
                }
                concreteTopics.addAll(foundTopics);
            }
            EndpointReferenceType subsRef = this.subscriptionManagerService.createAndStoreSubscriptionResource(subscriptionId, concreteTopics, request);
            reponse = RefinedWsnbFactory.getInstance().createSubscribeResponse(subsRef);
            reponse.setCurrentTime(new Date());
            Date termTime = this.subscriptionManagerService.getTerminationTimeOfSubscription(subscriptionId);
            if (termTime != null) {
                reponse.setTerminationTime(termTime);
            }
        }
        catch (WstopException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WsrfbfException e) {
            throw new WsnbException((Throwable)e);
        }
        return reponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResourcePropertyResponse getResourceProperty(QName property) throws WsnbException, AbsWSStarFault {
        GetResourcePropertyResponse response = null;
        ArrayList<Element> values = null;
        try {
            if (property.equals(WstopConstants.TOPIC_SET_QNAME)) {
                TopicSetType topicSetRP = this.actorAsRP.getTopicSet();
                if (topicSetRP == null) throw this.createInvalidResourcePropertyQNameFault();
                values = new ArrayList<Element>();
                values.add(Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(topicSetRP).getDocumentElement());
            } else if (property.equals(WsnbConstants.FIXED_TOPIC_SET_QNAME)) {
                Boolean isFixedTopicSetRP = this.actorAsRP.isFixedTopicSet();
                if (isFixedTopicSetRP == null) throw this.createInvalidResourcePropertyQNameFault();
                values = new ArrayList();
                values.add(Wsnb4ServUtils.createPropertyAsElement(property, isFixedTopicSetRP.toString()));
            } else if (property.equals(WsnbConstants.TOPIC_EXPRESSION_QNAME)) {
                List topicExprList = this.actorAsRP.getTopicExpressions();
                if (topicExprList == null) throw this.createInvalidResourcePropertyQNameFault();
                values = new ArrayList();
                for (TopicExpressionType topExprItem : topicExprList) {
                    values.add(Wsnb4ServUtils.getWsnbWriter().writeTopicExpressionTypeAsDOM(topExprItem).getDocumentElement());
                }
            } else if (property.equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME)) {
                values = new ArrayList();
                List topicExprDialectList = this.actorAsRP.getTopicExpressionDialects();
                if (topicExprDialectList == null) throw this.createInvalidResourcePropertyQNameFault();
                values = new ArrayList();
                for (URI dialectItem : topicExprDialectList) {
                    values.add(Wsnb4ServUtils.createPropertyAsElement(property, dialectItem.toString()));
                }
            }
            if (values == null) {
                throw this.createInvalidResourcePropertyQNameFault();
            }
            response = RefinedWsrfrpFactory.getInstance().createGetResourcePropertyResponse();
            response.setPropertyValue(values);
            return response;
        }
        catch (WsrfrpException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WstopException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    private InvalidResourcePropertyQNameFault createInvalidResourcePropertyQNameFault() throws WsnbException {
        try {
            return new InvalidResourcePropertyQNameFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message");
        }
        catch (WsrfrpException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WsrfbfException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    public UpdateResourcePropertiesResponse updateResourceProperties(UpdateResourceProperties request) throws WsnbException, AbsWSStarFault {
        UpdateResourcePropertiesResponse response = null;
        try {
            UpdateType content = request.getUpdate();
            List properties = content.getUpdateContent();
            for (Element propItem : properties) {
                ResourcePropertyChangeFailureType failure;
                if (propItem.getLocalName().equals(WsnbConstants.FIXED_TOPIC_SET_QNAME.getLocalPart()) && propItem.getNamespaceURI().equals(WsnbConstants.FIXED_TOPIC_SET_QNAME.getNamespaceURI())) {
                    this.actorAsRP.setFixedTopicSet(new Boolean(propItem.getTextContent()));
                    continue;
                }
                if (propItem.getLocalName().equals(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart()) && propItem.getNamespaceURI().equals(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI())) {
                    failure = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", failure);
                }
                if (propItem.getLocalName().equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME.getLocalPart()) && propItem.getNamespaceURI().equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME.getNamespaceURI())) {
                    failure = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", failure);
                }
                if (propItem.getLocalName().equals(WstopConstants.TOPIC_SET_QNAME.getLocalPart()) && propItem.getNamespaceURI().equals(WstopConstants.TOPIC_SET_QNAME.getNamespaceURI())) {
                    if (!this.actorAsRP.isFixedTopicSet().booleanValue()) {
                        Document topicSetAsDOM = propItem.getOwnerDocument();
                        TopicSetType newTopicSet = Wsnb4ServUtils.getWstopReader().readTopicSetType(topicSetAsDOM);
                        this.actorAsRP.setTopicSet(newTopicSet);
                        this.notifyTopicSetResourceModification(newTopicSet, this.actorAsRP.getTopicSet());
                        this.updateStoredCurrentMsgList(topicSetAsDOM);
                        try {
                            List<String> uuidsOfToTerminateSubscription = this.subscriptionManagerService.lookForSubscriptionToTerminate(topicSetAsDOM, this.topicsManager);
                            for (String uuidItem : uuidsOfToTerminateSubscription) {
                                this.subscriptionManagerService.terminateSubscription(uuidItem);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    failure = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", failure);
                }
                throw this.createInvalidResourcePropertyQNameFault();
            }
            response = RefinedWsrfrpFactory.getInstance().createUpdateResourcePropertiesResponse();
        }
        catch (WsrfrpException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WstopException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WsrfbfException e) {
            throw new WsnbException((Throwable)e);
        }
        return response;
    }

    private void notifyTopicSetResourceModification(TopicSetType newTopicSet, TopicSetType topicSet) throws WsnbException {
        if (this.notificationSender != null) {
            try {
                Element newTopicSetAsElt = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(newTopicSet).getDocumentElement();
                Element oldTopicSetAsElt = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(topicSet).getDocumentElement();
                ResourcePropertyValueChangeNotificationType.NewValues newTopicSetValue = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationTypeNewValues(newTopicSetAsElt);
                ResourcePropertyValueChangeNotificationType.OldValues oldTopicSetValue = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationTypeOldValues(oldTopicSetAsElt);
                ResourcePropertyValueChangeNotificationType notifMessage = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationType(newTopicSetValue);
                notifMessage.setOldValues(oldTopicSetValue);
                Document notifAsDoc = Wsnb4ServUtils.getWsrfrpWriter().writeResourcePropertyValueChangeNotificationTypeAsDOM(notifMessage);
                NotificationMessageHolderType.Message message = RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifAsDoc.getDocumentElement());
                NotificationMessageHolderType formattedNotif = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(message);
                TopicExpressionType topic = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.SIMPLE_TOPIC_EXPRESSION_DIALECT_URI);
                topic.setContent((Object)this.factory.createSimpleTopicExpression(new QName(this.topicNSForRPChangeValueNotif.getNamespace().toString(), this.topicNSForRPChangeValueNotif.getName(), this.associatedNSPrefix)));
                formattedNotif.setTopic(topic);
                Notify notifPayload = RefinedWsnbFactory.getInstance().createNotify(formattedNotif);
                List<String> subscriptionUuids = this.subscriptionManagerService.getStoredSubscriptionUuids();
                ArrayList<EndpointReferenceType> consumerAlreadyNotified = new ArrayList<EndpointReferenceType>();
                EndpointReferenceType currentConsumerEdp = null;
                for (String uuidItem : subscriptionUuids) {
                    currentConsumerEdp = this.subscriptionManagerService.getConsumerEdpRefOfSubscription(uuidItem);
                    if (!this.mustBeNotified(currentConsumerEdp, consumerAlreadyNotified)) continue;
                    this.notificationSender.sendNotifyRequest(currentConsumerEdp, notifPayload);
                    consumerAlreadyNotified.add(currentConsumerEdp);
                }
            }
            catch (WsrfrpException e) {
                throw new WsnbException((Throwable)e);
            }
            catch (WstopException e) {
                throw new WsnbException((Throwable)e);
            }
        }
    }

    private boolean mustBeNotified(EndpointReferenceType currentConsumerEdp, List<EndpointReferenceType> edpList) {
        boolean result = true;
        return result;
    }

    private void updateStoredCurrentMsgList(Document topicSetAsDOM) throws WsnbException {
        ArrayList<QName> currentMessageToRemoveKey = new ArrayList<QName>();
        TopicExpressionType currentConcreteTopExpr = null;
        int currentPrefixIndex = -1;
        String currentLocalPart = null;
        for (QName keyItem : this.currentMessages.keySet()) {
            currentLocalPart = keyItem.getLocalPart();
            currentPrefixIndex = currentLocalPart.indexOf(":");
            currentConcreteTopExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            EJaxbConcreteTopicExpressionWithQName conTop = new EJaxbConcreteTopicExpressionWithQName();
            conTop.setConcreteTopicExpression(currentLocalPart);
            EJaxbConcreteTopicExpressionWithQName.Namespace ns = new EJaxbConcreteTopicExpressionWithQName.Namespace();
            ns.setPrefix(currentLocalPart.substring(0, currentPrefixIndex));
            ns.setUri(keyItem.getNamespaceURI());
            conTop.getNamespace().add(ns);
            if (this.topicsManager.isSupportedTopic(currentConcreteTopExpr, topicSetAsDOM)) continue;
            currentMessageToRemoveKey.add(keyItem);
        }
        for (QName keyitem : currentMessageToRemoveKey) {
            this.currentMessages.remove(keyitem);
        }
    }
}

