/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.engines;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsn.t_1_extension.EJaxbConcreteTopicExpressionWithQName;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.utils.WsrfrException;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTimeResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.ISubscriptionManager;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnableToDestroySubscriptionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.persistence.WsnbPersistence;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.wsresources.WsnSubscription;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscriptionManagerEngine
implements ISubscriptionManager {
    protected Logger logger;
    protected Map<String, WsnSubscription> subscriptions;
    protected Map<QName, List<String>> uuidsPerTopics;
    protected WsnbPersistence persistenceMgr;
    protected String subscriptionsManagerEdp = "";
    protected QName subscriptionsManagerService = null;
    protected QName subscriptionsManagerInterface = null;
    protected String targetSubscriptionResourceUuid = "";
    protected ITransporterForWsnbPublisher notificationSender = null;

    public SubscriptionManagerEngine(Logger logger, WsnbPersistence persistenceMgr, ITransporterForWsnbPublisher transporter) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, WsnSubscription>();
        this.uuidsPerTopics = new ConcurrentHashMap<QName, List<String>>();
        this.persistenceMgr = persistenceMgr;
        this.notificationSender = transporter;
    }

    public SubscriptionManagerEngine(Logger logger) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, WsnSubscription>();
        this.uuidsPerTopics = new ConcurrentHashMap<QName, List<String>>();
        this.persistenceMgr = null;
    }

    public String getSubscriptionsManagerEdp() {
        return this.subscriptionsManagerEdp;
    }

    public void setSubscriptionsManagerEdp(String subscriptionsMgrEdp) {
        this.subscriptionsManagerEdp = subscriptionsMgrEdp;
    }

    public QName getSubscriptionsManagerService() {
        return this.subscriptionsManagerService;
    }

    public void setSubscriptionsManagerService(QName subscriptionsMgrService) {
        this.subscriptionsManagerService = subscriptionsMgrService;
    }

    public QName getSubscriptionsManagerInterface() {
        return this.subscriptionsManagerInterface != null ? this.subscriptionsManagerInterface : WsnbConstants.SUBSCRIPTION_MANAGER_INTERFACE;
    }

    public void setSubscriptionsManagerInterface(QName subscriptionsMgrInterface) {
        this.subscriptionsManagerInterface = subscriptionsMgrInterface;
    }

    public List<String> getStoredSubscriptionUuids() {
        return new CopyOnWriteArrayList<String>(this.subscriptions.keySet());
    }

    public void setTargetSubscriptionResourceUuid(String subscriptionUuid) {
        this.targetSubscriptionResourceUuid = subscriptionUuid;
    }

    public ITransporterForWsnbPublisher getNotificationSender() {
        return this.notificationSender;
    }

    public void setNotificationSender(ITransporterForWsnbPublisher notificationSender) {
        this.notificationSender = notificationSender;
    }

    private void throwSubscriptionUuidNotSetException(String methodName) throws WsnbException, ResourceUnknownFault {
        this.logger.log(Level.WARNING, "The target Subscription Uuid value is not set.\nYou must first call \"SubscriptionManagerEngine.setTargetSubscriptionResourceUuid(String uuid)\" method before \"" + methodName + "(...)\" method !!");
        try {
            throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
        }
        catch (WsrfrException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (WsrfbfException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe payload) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Unsubscribe\" request ...");
        try {
            if ((this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) && payload.getAny().size() > 0) {
                Element element;
                if (payload.getAny().get(0) instanceof JAXBElement) {
                    JAXBElement eprElmt = (JAXBElement)payload.getAny().get(0);
                    if (eprElmt.getValue() instanceof EJaxbEndpointReferenceType) {
                        String subscriptionResourceUuid;
                        EJaxbEndpointReferenceType epr = (EJaxbEndpointReferenceType)eprElmt.getValue();
                        Element subscriptionResourceUuidElmt = (Element)epr.getReferenceParameters().getAny().get(0);
                        this.targetSubscriptionResourceUuid = subscriptionResourceUuid = subscriptionResourceUuidElmt.getFirstChild().getNodeValue();
                    }
                } else if (payload.getAny().get(0) instanceof Element && (element = (Element)payload.getAny().get(0)).getLocalName().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getLocalPart()) && element.getNamespaceURI().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getNamespaceURI())) {
                    this.targetSubscriptionResourceUuid = element.getTextContent();
                }
            }
            if (this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) {
                this.throwSubscriptionUuidNotSetException("unsubscribe");
            }
            WsnSubscription wsnSubscription = null;
            if (this.subscriptions.containsKey(this.targetSubscriptionResourceUuid)) {
                wsnSubscription = this.subscriptions.remove(this.targetSubscriptionResourceUuid);
                if (this.subscriptions.containsKey(this.targetSubscriptionResourceUuid)) {
                    try {
                        throw new UnableToDestroySubscriptionFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager was unable to destroy the Subscription resource for some reason.");
                    }
                    catch (WsrfbfException e) {
                        throw new WsnbException((Throwable)e);
                    }
                }
                this.removeUuidFromUuidsPerTopic(this.targetSubscriptionResourceUuid);
                if (this.persistenceMgr != null) {
                    this.persistenceMgr.removeSubscription(this.targetSubscriptionResourceUuid);
                }
            } else {
                try {
                    throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
                }
                catch (WsrfrException e) {
                    throw new WsnbException((Throwable)e);
                }
                catch (WsrfbfException e) {
                    throw new WsnbException((Throwable)e);
                }
            }
            wsnSubscription.destroy(RefinedWsrfrlFactory.getInstance().createDestroy());
        }
        catch (WsrfrlException e) {
            throw new WsnbException((Throwable)e);
        }
        this.targetSubscriptionResourceUuid = "";
        return RefinedWsnbFactory.getInstance().createUnsubscribeResponse();
    }

    private void removeUuidFromUuidsPerTopic(String subscriptionUuid) {
        List<String> currentUuids2 = null;
        for (List<String> currentUuids2 : this.uuidsPerTopics.values()) {
            currentUuids2.remove(subscriptionUuid);
        }
    }

    public RenewResponse renew(Renew payload) throws WsnbException, AbsWSStarFault {
        SetTerminationTimeResponse responseFromResource;
        this.logger.log(Level.FINE, "performs a \"Renew\" request ...");
        if (this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) {
            this.throwSubscriptionUuidNotSetException("renew");
        }
        RenewResponse response = null;
        WsnSubscription subscription = this.subscriptions.get(this.targetSubscriptionResourceUuid);
        if (subscription == null) {
            try {
                throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
            catch (WsrfrException e) {
                throw new WsnbException((Throwable)e);
            }
            catch (WsrfbfException e) {
                throw new WsnbException((Throwable)e);
            }
        }
        Object requestedTerminationTime = payload.getTerminationTime();
        SetTerminationTime payloadForResource = null;
        try {
            payloadForResource = requestedTerminationTime instanceof Duration ? RefinedWsrfrlFactory.getInstance().createSetTerminationTime((Duration)requestedTerminationTime) : RefinedWsrfrlFactory.getInstance().createSetTerminationTime((Date)requestedTerminationTime);
        }
        catch (WsrfrlException e) {
            throw new WsnbException((Throwable)e);
        }
        try {
            responseFromResource = subscription.setTerminationTime(payloadForResource);
        }
        catch (WsrfrlException e) {
            throw new WsnbException((Throwable)e);
        }
        response = RefinedWsnbFactory.getInstance().createRenewResponse(responseFromResource.getNewTerminationTime());
        response.setCurrentTime(responseFromResource.getCurrentTime());
        this.targetSubscriptionResourceUuid = "";
        return response;
    }

    public EndpointReferenceType createAndStoreSubscriptionResource(String subscriptionId, List<TopicExpressionType> topics, Subscribe payload) throws WsnbException, AbsWSStarFault {
        WsnSubscription subscription = null;
        try {
            URI address = new URI(this.subscriptionsManagerService.getNamespaceURI() + "::" + this.subscriptionsManagerService.getLocalPart() + "@" + this.subscriptionsManagerEdp);
            subscription = new WsnSubscription(this.logger, address, subscriptionId, payload, this.notificationSender);
            subscription.setAssociatedTopicExprs(topics);
        }
        catch (URISyntaxException e) {
            throw new WsnbException((Throwable)e);
        }
        this.subscriptions.put(subscriptionId, subscription);
        if (this.persistenceMgr != null) {
            this.persistenceMgr.persist(subscription.getSubscriptionResource(), subscriptionId);
        }
        this.storeUuidInUuidsPerTopicsList(subscriptionId, topics);
        return subscription.getSubscriptionReference();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeUuidInUuidsPerTopicsList(String subscriptionId, List<TopicExpressionType> topics) throws WsnbException {
        QName currentTopic = null;
        List<String> currentUuids = null;
        for (TopicExpressionType topicItem : topics) {
            if (topicItem.getContent() instanceof JAXBElement) {
                JAXBElement elmt = (JAXBElement)topicItem.getContent();
                if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type unknown");
                currentTopic = (QName)elmt.getValue();
            } else {
                if (!(topicItem.getContent() instanceof EJaxbConcreteTopicExpressionWithQName)) throw new WsnbException("TopicExpression type not supported here");
                EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)topicItem.getContent();
                currentTopic = new QName(msgTopic.getConcreteTopicExpression());
            }
            if (this.uuidsPerTopics.containsKey(currentTopic)) {
                currentUuids = this.uuidsPerTopics.get(currentTopic);
                if (currentUuids.contains(subscriptionId)) continue;
                currentUuids.add(subscriptionId);
                continue;
            }
            CopyOnWriteArrayList<String> newUuidsList = new CopyOnWriteArrayList<String>();
            newUuidsList.add(subscriptionId);
            this.uuidsPerTopics.put(currentTopic, newUuidsList);
        }
    }

    public List<String> removeAllSubscription() throws WsnbException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.subscriptions.keySet());
        for (String subscriptionUuidItem : this.subscriptions.keySet()) {
            if (this.persistenceMgr == null) continue;
            this.persistenceMgr.removeSubscription(subscriptionUuidItem);
        }
        this.subscriptions.clear();
        this.uuidsPerTopics.clear();
        return result;
    }

    public EndpointReferenceType getConsumerEdpRefOfSubscription(String subscriptionId) throws WsnbException {
        EndpointReferenceType consumerEdp = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null) {
            consumerEdp = subsResource.getConsumerEdpRef();
        }
        return consumerEdp;
    }

    public EndpointReferenceType getSubscriptionRef(String subscriptionId) throws WsnbException {
        EndpointReferenceType subsRef = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null) {
            subsRef = subsResource.getSubscriptionReference();
        }
        return subsRef;
    }

    public List<TopicExpressionType> getTopicExpressionOfSubscription(String subscriptionId) throws WsnbException {
        List<TopicExpressionType> topExprList = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null) {
            topExprList = subsResource.getTopicExpressionOfSubscription();
        }
        return topExprList;
    }

    public FilterType getFilterOfSubscription(String subscriptionId) throws WsnbException {
        FilterType filter = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null) {
            filter = subsResource.getFilterOfSubscription();
        }
        return filter;
    }

    public SubscriptionPolicyType getPolicyOfSubscription(String subscriptionId) throws WsnbException {
        SubscriptionPolicyType policy = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null) {
            policy = subsResource.getPolicyOfSubscription();
        }
        return policy;
    }

    public Date getTerminationTimeOfSubscription(String subscriptionId) throws WsnbException {
        Date terminationTime = null;
        WsnSubscription subsResource = this.subscriptions.get(subscriptionId);
        if (subsResource != null && subsResource.getTerminationTime() != null) {
            terminationTime = subsResource.getTerminationTime().getValue();
        }
        return terminationTime;
    }

    public void removeExpiredSubscription(String subscriptionId) throws WsnbException {
        if (this.subscriptions.containsKey(subscriptionId)) {
            this.subscriptions.remove(subscriptionId);
            this.removeUuidFromUuidsPerTopic(subscriptionId);
            if (this.persistenceMgr != null) {
                this.persistenceMgr.removeSubscription(subscriptionId);
            }
        }
    }

    public void restorePersistedSubscriptions(TopicsManagerEngine topicsMgr, Document supportedTopicsAsDOM) throws WsnbException, AbsWSStarFault {
        if (this.persistenceMgr != null) {
            Map<String, SubscriptionManagerRP> subsRPToRestore = this.persistenceMgr.getSubscriptionsToRestore();
            Set<String> rIds = subsRPToRestore.keySet();
            SubscriptionManagerRP currentSubsRP = null;
            URI wsaAddress = null;
            List topExprList = null;
            WsnSubscription currentWSSubs = null;
            CopyOnWriteArrayList<TopicExpressionType> currentConcreteTopicExprs = null;
            for (String idItem : rIds) {
                try {
                    wsaAddress = new URI(this.subscriptionsManagerService.getNamespaceURI() + "::" + this.subscriptionsManagerService.getLocalPart() + "@" + this.subscriptionsManagerEdp);
                }
                catch (URISyntaxException e) {
                    throw new WsnbException((Throwable)e);
                }
                currentSubsRP = subsRPToRestore.get(idItem);
                currentWSSubs = new WsnSubscription(this.logger, wsaAddress, idItem, currentSubsRP);
                topExprList = currentSubsRP.getFilter().getTopicExpressions();
                currentConcreteTopicExprs = new CopyOnWriteArrayList<TopicExpressionType>();
                for (TopicExpressionType topExprItem : topExprList) {
                    currentConcreteTopicExprs.addAll(topicsMgr.getTopicsAsConcreteTopExpr(topExprItem, supportedTopicsAsDOM));
                }
                currentWSSubs.setAssociatedTopicExprs(currentConcreteTopicExprs);
                this.subscriptions.put(idItem, currentWSSubs);
                this.storeUuidInUuidsPerTopicsList(idItem, currentConcreteTopicExprs);
            }
        }
    }

    public List<String> lookForSubscriptionToTerminate(Document topicSetAsDOM, TopicsManagerEngine wstopEngine) throws WsnbException {
        CopyOnWriteArrayList<String> uuids = new CopyOnWriteArrayList<String>();
        TopicExpressionType currentConcreteTopExpr = null;
        int currentPrefixIndex = -1;
        String currentLocalPart = null;
        WsnSubscription currentSubscriptionToUpdate = null;
        for (QName keyItem : this.uuidsPerTopics.keySet()) {
            currentLocalPart = keyItem.getLocalPart();
            currentPrefixIndex = currentLocalPart.indexOf(":");
            currentConcreteTopExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            EJaxbConcreteTopicExpressionWithQName conTop = new EJaxbConcreteTopicExpressionWithQName();
            conTop.setConcreteTopicExpression(currentLocalPart);
            if (currentPrefixIndex > 0) {
                EJaxbConcreteTopicExpressionWithQName.Namespace ns = new EJaxbConcreteTopicExpressionWithQName.Namespace();
                ns.setPrefix(currentLocalPart.substring(0, currentPrefixIndex));
                ns.setUri(keyItem.getNamespaceURI());
                conTop.getNamespace().add(ns);
            }
            currentConcreteTopExpr.setContent((Object)conTop);
            if (wstopEngine.isSupportedTopic(currentConcreteTopExpr, topicSetAsDOM)) continue;
            List<String> subscriptionUuidsToCheck = this.uuidsPerTopics.get(keyItem);
            for (String uuidItem : subscriptionUuidsToCheck) {
                currentSubscriptionToUpdate = this.subscriptions.get(uuidItem);
                if (currentSubscriptionToUpdate.removeAssociatedTopicExpr(currentConcreteTopExpr) > 0 || uuids.contains(uuidItem)) continue;
                uuids.add(uuidItem);
            }
        }
        return uuids;
    }

    public void terminateSubscription(String subscriptionUuid) throws WsnbException, AbsWSStarFault {
        WsnSubscription subscription = this.subscriptions.remove(subscriptionUuid);
        List<TopicExpressionType> concreteTopic = subscription.getAssociatedTopicExprs();
        List<String> currentUuids = null;
        for (TopicExpressionType concreteTopicItem : concreteTopic) {
            currentUuids = this.uuidsPerTopics.get(concreteTopicItem);
            if (currentUuids == null) continue;
            currentUuids.remove(subscriptionUuid);
        }
        try {
            subscription.destroy(RefinedWsrfrlFactory.getInstance().createDestroy());
        }
        catch (WsrfrlException e) {
            throw new WsnbException((Throwable)e);
        }
        subscription = null;
    }
}

