/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.persistence;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WsnbPersistence {
    private File subscriptions_folder = null;

    public WsnbPersistence(File subscriptions_path) {
        if (subscriptions_path == null) {
            throw new NullPointerException("Persistence folder must not be null");
        }
        if (!subscriptions_path.exists()) {
            subscriptions_path.mkdirs();
        }
        this.subscriptions_folder = subscriptions_path;
    }

    public void persist(SubscriptionManagerRP subscriptionRP, String uuid) throws WsnbException {
        RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscriptionManagerRPToFilesystem(subscriptionRP, this.subscriptions_folder.getAbsoluteFile() + File.separator + uuid);
    }

    public Map<String, SubscriptionManagerRP> getSubscriptionsToRestore() throws WsnbException {
        ConcurrentHashMap<String, SubscriptionManagerRP> result = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        if (this.subscriptions_folder.exists()) {
            File[] persistedSubsriptionFiles = this.subscriptions_folder.listFiles();
            int i = 0;
            while (i < persistedSubsriptionFiles.length) {
                result.put(persistedSubsriptionFiles[i].getName(), RefinedWsnbFactory.getInstance().getWsnbReader().readSubscriptionManagerRP(persistedSubsriptionFiles[i]));
                ++i;
            }
        }
        return result;
    }

    public void removeSubscription(String uuid) throws WsnbException {
        File subscriptionToRemove = new File(this.subscriptions_folder, uuid);
        if (subscriptionToRemove.exists()) {
            subscriptionToRemove.delete();
        }
    }
}

