/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.topic;

import com.ebmwebsourcing.wsn.t_1_extension.EJaxbConcreteTopicExpressionWithQName;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.XPathDOMAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TopicsManagerEngine {
    private static final String FLAG_TOPIC_EQUAL_TRUE = "[@wstop:topic='true']";
    private final XPathDOMAnalyzer xpathAnalyser = new XPathDOMAnalyzer();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<TopicExpressionType> getTopicsAsConcreteTopExpr(TopicExpressionType topicExpression, Document supportedTopicsAsDOM) throws WsnbException {
        CopyOnWriteArrayList<TopicExpressionType> concreteTopics = new CopyOnWriteArrayList<TopicExpressionType>();
        ArrayList<QName> namespaces = new ArrayList<QName>();
        String contentExpr = null;
        if (topicExpression.getContent() instanceof JAXBElement) {
            JAXBElement elmt = (JAXBElement)topicExpression.getContent();
            if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type unknown");
            QName top = (QName)elmt.getValue();
            namespaces.add(new QName(top.getNamespaceURI().trim(), top.getPrefix().trim()));
            contentExpr = top.getPrefix() != null ? top.getPrefix() + ":" + top.getLocalPart() : top.getLocalPart();
        } else {
            if (!(topicExpression.getContent() instanceof EJaxbConcreteTopicExpressionWithQName)) throw new WsnbException("TopicExpression type unknown");
            EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)topicExpression.getContent();
            for (EJaxbConcreteTopicExpressionWithQName.Namespace ns : msgTopic.getNamespace()) {
                namespaces.add(new QName(ns.getUri().trim(), ns.getPrefix().trim()));
            }
            contentExpr = msgTopic.getConcreteTopicExpression();
        }
        NodeList topicNodes = this.lookForNodes(contentExpr, namespaces, supportedTopicsAsDOM);
        for (int i = 0; i < topicNodes.getLength(); ++i) {
            Node currentNode = topicNodes.item(i);
            if (currentNode.getNodeType() != 1) continue;
            concreteTopics.add(this.getConcreteTopicExpression(currentNode, namespaces));
        }
        return concreteTopics;
    }

    private NodeList lookForNodes(String contentExpr, List<QName> namespaces, Document supportedTopicsAsDOM) throws WsnbException {
        ConcurrentHashMap<String, String> prefixMappings = new ConcurrentHashMap<String, String>();
        for (QName qNamItem : namespaces) {
            prefixMappings.put(qNamItem.getLocalPart(), qNamItem.getNamespaceURI());
        }
        prefixMappings.put("wstop", "http://docs.oasis-open.org/wsn/t-1");
        String expressionToEvalute = "//" + contentExpr + (!contentExpr.endsWith(FLAG_TOPIC_EQUAL_TRUE) ? FLAG_TOPIC_EQUAL_TRUE : "");
        return this.xpathAnalyser.evaluate(expressionToEvalute, supportedTopicsAsDOM, prefixMappings);
    }

    private TopicExpressionType getConcreteTopicExpression(Node topicNode, List<QName> namespaces) throws WsnbException {
        TopicExpressionType concreteTopExp = null;
        Element currentElement = (Element)topicNode;
        Node currentNode = topicNode;
        String content = "";
        String prefix = null;
        do {
            content = currentElement.getNodeName() + (content.length() > 0 ? "/" : "") + content;
            currentNode = currentNode.getParentNode();
            Element element = currentElement = currentNode != null ? (Element)currentNode : null;
        } while (currentElement != null && !currentElement.getNodeName().equals(WstopConstants.TOPIC_SET_QNAME.getPrefix() + ":" + WstopConstants.TOPIC_SET_QNAME.getLocalPart()));
        if (content.indexOf(":") > 0) {
            prefix = content.substring(0, content.indexOf(":"));
        }
        concreteTopExp = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
        EJaxbConcreteTopicExpressionWithQName conTop = new EJaxbConcreteTopicExpressionWithQName();
        conTop.setConcreteTopicExpression(content);
        for (QName qNameItem : namespaces) {
            EJaxbConcreteTopicExpressionWithQName.Namespace ns = new EJaxbConcreteTopicExpressionWithQName.Namespace();
            ns.setPrefix(prefix);
            ns.setUri(qNameItem.getNamespaceURI());
            conTop.getNamespace().add(ns);
        }
        concreteTopExp.setContent((Object)conTop);
        return concreteTopExp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupportedTopic(TopicExpressionType concreteTopicExpression, Document supportedTopicsAsDOM) throws WsnbException {
        boolean result = false;
        if (!concreteTopicExpression.getDialect().equals(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI)) return result;
        ArrayList<QName> namespaces = new ArrayList<QName>();
        String contentExpr = null;
        if (concreteTopicExpression.getContent() instanceof JAXBElement) {
            JAXBElement elmt = (JAXBElement)concreteTopicExpression.getContent();
            if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type unknown");
            QName top = (QName)elmt.getValue();
            namespaces.add(new QName(top.getNamespaceURI(), top.getPrefix().trim()));
            contentExpr = top.getPrefix() != null ? top.getPrefix().trim() + ":" + top.getLocalPart() : top.getLocalPart();
        } else {
            if (!(concreteTopicExpression.getContent() instanceof EJaxbConcreteTopicExpressionWithQName)) throw new WsnbException("TopicExpression type unknown");
            EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)concreteTopicExpression.getContent();
            for (EJaxbConcreteTopicExpressionWithQName.Namespace ns : msgTopic.getNamespace()) {
                namespaces.add(new QName(ns.getUri(), ns.getPrefix()));
            }
            contentExpr = msgTopic.getConcreteTopicExpression();
        }
        NodeList nodes = this.lookForNodes(contentExpr, namespaces, supportedTopicsAsDOM);
        if (nodes == null) return false;
        if (nodes.getLength() != 1) return false;
        return true;
    }
}

