/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.reasoner.api.engine;

import java.net.URI;
import java.util.Set;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface Reasoner {
	
	boolean isConsistent();
	
	boolean isInstance(URI instance);
	
	boolean isConcept(URI concept);
	
	boolean isThingOrNothing(URI concept);
	
	void infer();
	
	Set<URI> getSuperClasses(URI concept);
	
	Set<URI> getSubClasses(URI concept);
	
	Set<URI> getEquivalentClasses(URI concept);
	
	Set<URI> getIndividuals(URI concept);
	
	Set<URI> getSimilarIndividuals(URI individual);
	
	Set<URI> getTypes(URI individual);
	
	boolean isTechnicalConcept(URI concept);

}
