/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.impl.ontology;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OWLOntologyMerger;

public class OntologyManagerImpl
implements OntologyManager {
    Logger logger = Logger.getLogger(this.getClass().toString());
    private OWLOntologyManager owlManager = OWLManager.createOWLOntologyManager();
    private Map<URI, Boolean> ontologyUris = new HashMap<URI, Boolean>();
    private static final IRI EASIERSBS_ONTO_URI = IRI.create((String)"http://www.ebmwebsourcing.com/ontologies/easiersbs.owl");
    private boolean hasNewOnto = false;

    public void clearOntology() {
        Set set = this.owlManager.getOntologies();
        for (OWLOntology oWLOntology : set) {
            IRI iRI = this.owlManager.getOntologyDocumentIRI(oWLOntology);
            this.owlManager.removeOntology(oWLOntology);
            this.logger.finest("Ontology " + iRI + " deleted.");
        }
        this.ontologyUris.clear();
        this.logger.finest("All ontologies deleted!");
    }

    public void importOntology(URI uRI, boolean bl) throws ReasonerException {
        try {
            this.owlManager.setSilentMissingImportsHandling(true);
            OWLOntology oWLOntology = this.owlManager.loadOntology(IRI.create((URI)uRI));
            this.ontologyUris.put(uRI, bl);
            for (OWLDatatype oWLDatatype : oWLOntology.getDatatypesInSignature()) {
                this.owlManager.removeAxioms(oWLOntology, oWLDatatype.getReferencingAxioms(oWLOntology));
            }
            this.hasNewOnto = true;
            this.logger.fine("Ontology " + uRI.toString() + " succefully added.");
        }
        catch (OWLOntologyAlreadyExistsException oWLOntologyAlreadyExistsException) {
            this.logger.warning("Ontology already imported (URI: " + uRI + ")");
        }
        catch (OWLOntologyDocumentAlreadyExistsException oWLOntologyDocumentAlreadyExistsException) {
            this.logger.warning("Ontology already imported (URI: " + uRI + ")");
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new ReasonerException("Problem during ontology import", (Throwable)oWLOntologyCreationException);
        }
    }

    public void importOntology(URI uRI) throws ReasonerException {
        this.importOntology(uRI, false);
    }

    public void importOntology(File file, boolean bl) throws ReasonerException {
        this.importOntology(file.toURI(), bl);
    }

    public void importOntology(File file) throws ReasonerException {
        this.importOntology(file, false);
    }

    public void exportOntology(URI uRI) throws ReasonerException {
        try {
            OWLOntology oWLOntology = this.getMergedOntology();
            this.owlManager.saveOntology(oWLOntology, (OWLOntologyFormat)new RDFXMLOntologyFormat(), IRI.create((URI)uRI));
        }
        catch (OWLOntologyStorageException oWLOntologyStorageException) {
            throw new ReasonerException("Problem during global ontology export in " + uRI.toString(), (Throwable)oWLOntologyStorageException);
        }
    }

    public OWLOntology getMergedOntology() throws ReasonerException {
        OWLOntologyMerger oWLOntologyMerger = new OWLOntologyMerger((OWLOntologySetProvider)this.owlManager);
        OWLOntology oWLOntology = this.owlManager.getOntology(EASIERSBS_ONTO_URI);
        if (this.hasNewOnto || oWLOntology == null) {
            if (oWLOntology != null) {
                this.owlManager.removeOntology(oWLOntology);
            }
            try {
                oWLOntology = oWLOntologyMerger.createMergedOntology(this.owlManager, EASIERSBS_ONTO_URI);
            }
            catch (OWLOntologyCreationException oWLOntologyCreationException) {
                throw new ReasonerException("Problem during ontology merge", (Throwable)oWLOntologyCreationException);
            }
            this.hasNewOnto = false;
        }
        return oWLOntology;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.owlManager;
    }

    public Map<URI, Integer> getOntologiesInfo() {
        HashMap<URI, Integer> hashMap = new HashMap<URI, Integer>();
        for (OWLOntology oWLOntology : this.owlManager.getOntologies()) {
            hashMap.put(oWLOntology.getOntologyID().getOntologyIRI().toURI(), oWLOntology.getAxiomCount());
        }
        return hashMap;
    }

    public Set<URI> getNamespaceUris() {
        return this.ontologyUris.keySet();
    }

    public boolean isTechnicalOntology(URI uRI) {
        if (this.ontologyUris.containsKey(uRI)) {
            return this.ontologyUris.get(uRI);
        }
        return false;
    }
}

