/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.impl.engine;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.ontology.OntologyManagerImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory;

public class ReasonerImpl
implements Reasoner {
    private OWLReasonerFactory reasonerFactory = new FaCTPlusPlusReasonerFactory();
    private OntologyManager easierOntoManager = null;
    private OWLOntologyManager owlapiManager = null;
    private OWLDataFactory owlapiDataFactory = null;
    private OWLOntology onto = null;
    private OWLReasoner reasoner = null;

    public ReasonerImpl(OntologyManager manager) throws ReasonerException {
        this.easierOntoManager = manager;
        this.owlapiManager = ((OntologyManagerImpl)manager).getOntologyManager();
        this.owlapiDataFactory = this.owlapiManager.getOWLDataFactory();
        this.onto = ((OntologyManagerImpl)manager).getMergedOntology();
        ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
        SimpleConfiguration config = new SimpleConfiguration((ReasonerProgressMonitor)progressMonitor);
        this.reasoner = this.reasonerFactory.createReasoner(this.onto, (OWLReasonerConfiguration)config);
        this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
        if (!this.reasoner.isConsistent()) {
            throw new ReasonerException("Inconsistent ontology" + this.onto.getOntologyID().toString());
        }
    }

    public Set<URI> getEquivalentClasses(URI conceptURI) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)conceptURI));
        Set eqClasses = this.reasoner.getEquivalentClasses((OWLClassExpression)conceptClass).getEntities();
        return this.getURIs(eqClasses);
    }

    public Set<URI> getSuperClasses(URI concept) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)concept));
        Set superClasses = this.reasoner.getSuperClasses((OWLClassExpression)conceptClass, true).getFlattened();
        return this.getURIs(superClasses);
    }

    public Set<URI> getSubClasses(URI concept) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)concept));
        Set subClasses = this.reasoner.getSubClasses((OWLClassExpression)conceptClass, true).getFlattened();
        return this.getURIs(subClasses);
    }

    public Set<URI> getIndividuals(URI concept) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)concept));
        Set individuals = this.reasoner.getInstances((OWLClassExpression)conceptClass, true).getFlattened();
        return this.getURIs(individuals);
    }

    public Set<URI> getSimilarIndividuals(URI individualURI) {
        OWLNamedIndividual individual = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)individualURI));
        Set types = this.reasoner.getTypes(individual, true).getFlattened();
        HashSet<URI> brothers = new HashSet<URI>();
        for (OWLClass parent : types) {
            brothers.addAll(this.getURIs(this.reasoner.getInstances((OWLClassExpression)parent, true).getFlattened()));
        }
        return brothers;
    }

    public Set<URI> getTypes(URI individualURI) {
        OWLNamedIndividual individual = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)individualURI));
        Set types = this.reasoner.getTypes(individual, true).getFlattened();
        return this.getURIs(types);
    }

    public void infer() {
        ArrayList<InferredSubClassAxiomGenerator> gens = new ArrayList<InferredSubClassAxiomGenerator>();
        gens.add(new InferredSubClassAxiomGenerator());
        InferredOntologyGenerator iog = new InferredOntologyGenerator(this.reasoner, gens);
        iog.fillOntology(this.owlapiManager, this.onto);
    }

    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    public boolean isInstance(URI uri) {
        OWLNamedIndividual indiv = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)uri));
        return this.onto.isDeclared((OWLEntity)indiv);
    }

    public boolean isConcept(URI uri) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uri));
        return this.onto.isDeclared((OWLEntity)conceptClass);
    }

    public boolean isThingOrNothing(URI uri) {
        OWLClass conceptClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uri));
        return conceptClass.isOWLThing() || conceptClass.isOWLNothing();
    }

    private Set<URI> getURIs(Set<? extends OWLNamedObject> owlObjects) {
        HashSet<URI> uris = new HashSet<URI>();
        Iterator<? extends OWLNamedObject> it = owlObjects.iterator();
        while (it.hasNext()) {
            uris.add(it.next().getIRI().toURI());
        }
        return uris;
    }

    public OWLOntology getReasonerOntology() {
        return this.onto;
    }

    public boolean isTechnicalConcept(URI concept) {
        String conceptBase = concept.toString().split("#")[0];
        URI conceptBaseUri = URI.create(conceptBase);
        return this.easierOntoManager.isTechnicalOntology(conceptBaseUri);
    }
}

