/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.model;

import java.util.Set;

import javax.xml.namespace.QName;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SemanticProfile {
	
	public QName getOperationQName();
	
	public void setOperationQName(QName operationQName);
	
	
	public Partner getPartner();
	
	public boolean hasPartner();
	
	public void setPartner(Partner partner);
	
	
	public Set<QName> getServiceQNames();
	
	public void addServiceQName(QName serviceQName);
	
	public void removeServiceQName(QName serviceQName);
	
	
	public SemanticPart getSemanticInterface();
	
	public void setSemanticInterface(SemanticPart semanticInterface);
	
	
	public SemanticPart getSemanticOperation();
	
	public void setSemanticOperation(SemanticPart semanticOperation);
	
	
	public Set<SemanticElement> getInputSemanticElements();
	
	public void setInputSemanticElements(Set<SemanticElement> semanticElements);
	
	public void addInputSemanticElement(SemanticElement semanticElement);
	
	public void removeInputSemanticElement(SemanticElement semanticElement);
	
	
	public Set<SemanticElement> getOutputSemanticElements();
	
	public void setOutputSemanticElements(Set<SemanticElement> semanticElements);
	
	public void addOutputSemanticElement(SemanticElement semanticElement);
	
	public void removeOutputSemanticElement(SemanticElement semanticElement);	

	
}
