/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.registry;

import java.net.URL;
import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface TechnicalServiceRegistry {

	public void addTechnicalService(QName serviceQName, Description wsdlDesc, URL wsdlUrl);
	
	public void removeTechnicalService(QName serviceQName);
	
	public Description getTechnicalService(QName serviceQName);
	
	public URL getWsdlUrl(QName serviceQName);
	
	public Set<URL> getWsdlUrls();
	
	public Set<Description> getAllTechnicalServices();
	
	public void removeAllTechnicalServices();
	
}
