/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.registry;

import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SemanticProfileRegistry {

	public void addSemanticProfile(SemanticProfile profile);
	
	public void removeSemanticProfile(QName operationQName);
	
	public SemanticProfile getSemanticProfile(QName operationQName);
	
	public Set<SemanticProfile> getAllSemanticProfiles();
	
	public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner);
	
	public void removeAllSemanticProfiles();
	
	public void removeSemanticProfilesByPartner(Partner partner);
	
}
