/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.matcher.computation.SemanticComputationImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SemanticMatcherImpl
extends AbstractMatcherImpl
implements SemanticMatcher {
    private Reasoner reasoner = null;
    private OntologyManager manager = null;
    private ExecutorService exec;
    private ExecutorCompletionService<RatedSemanticProfile> compExec;

    public SemanticMatcherImpl(ReasonerFactory factory, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException {
        this.registry = registry;
        this.props = props;
        this.manager = factory.getOntologyManager();
        this.reasoner = factory.newReasoner(this.manager);
        this.exec = Executors.newFixedThreadPool(props.getMaxThreads());
        this.compExec = new ExecutorCompletionService(this.exec);
    }

    public SemanticMatcherImpl(ReasonerFactory factory, SemanticRegistryManager registry) throws ReasonerException {
        this(factory, registry, new MatcherPropertiesImpl());
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public OntologyManager getOntologyManager() {
        return this.manager;
    }

    @Override
    public MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList) {
        MatchingResultImpl res = new MatchingResultImpl(profile);
        InferredProfile infProfile = profile.infer(this.reasoner, this.props);
        HashSet<Future<RatedSemanticProfile>> results = new HashSet<Future<RatedSemanticProfile>>();
        for (SemanticProfile service : serviceList) {
            SemanticComputationImpl semanticComputationImpl = new SemanticComputationImpl(this.props, infProfile, service);
            results.add(this.compExec.submit(semanticComputationImpl));
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (Future future : results) {
                if (future.isDone()) continue;
                done = false;
                break;
            }
            if (done) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Future future : results) {
            try {
                if (!(((RatedSemanticProfile)future.get()).getProfileRate() >= this.props.getSemanticThreshold())) continue;
                res.addResultProfile((RatedSemanticProfile)future.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }
}

