/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class SyntacticComputationImpl
implements Callable<RatedSemanticProfile> {
    private MatcherProperties props;
    private SimilarityMeasure similarity;
    private List<String> functionalWords;
    private List<String> inputWords;
    private List<String> outputWords;
    private SemanticProfile service;

    public SyntacticComputationImpl(MatcherProperties props, SimilarityMeasure similarity, List<String> functionalWords, List<String> inputWords, List<String> outputWords, SemanticProfile targetService) {
        this.props = props;
        this.similarity = similarity;
        this.functionalWords = functionalWords;
        this.inputWords = inputWords;
        this.outputWords = outputWords;
        this.service = targetService;
    }

    @Override
    public RatedSemanticProfile call() throws Exception {
        RatedSemanticProfileImpl res = new RatedSemanticProfileImpl(this.service);
        Double funcRate = null;
        Double ioRate = null;
        if (this.props.getOperationWeight() != 0.0) {
            List<String> serviceFunctionalWords = SimilarityUtil.extractUriRelatedWords(((SemanticPart)this.service.getSemanticOperation()).getSemanticConcepts());
            serviceFunctionalWords.addAll(SimilarityUtil.splitInWords(((SemanticPart)this.service.getSemanticOperation()).getName()));
            serviceFunctionalWords.addAll(SimilarityUtil.extractUriRelatedWords(((SemanticPart)this.service.getSemanticInterface()).getSemanticConcepts()));
            serviceFunctionalWords.addAll(SimilarityUtil.splitInWords(((SemanticPart)this.service.getSemanticInterface()).getName()));
            funcRate = this.similarity.measureSimilarity(this.functionalWords, serviceFunctionalWords);
            res.setOperationRate(funcRate);
        }
        if (this.props.getInputOutputWeigth() != 0.0) {
            List<String> serviceInputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)this.service.getInputSemanticElement()));
            res.setInputRate(this.similarity.measureSimilarity(this.inputWords, serviceInputWords));
            List<String> serviceOutputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)this.service.getOutputSemanticElement()));
            res.setOutputRate(this.similarity.measureSimilarity(this.outputWords, serviceOutputWords));
            ioRate = (res.getInputRate() + res.getOutputRate()) / 2.0;
        }
        if (ioRate == null || ioRate.isNaN()) {
            res.setProfileRate(funcRate);
        } else if (funcRate == null || funcRate.isNaN()) {
            res.setProfileRate(ioRate);
        } else {
            res.setProfileRate(ioRate * this.props.getInputOutputWeigth() + funcRate * this.props.getOperationWeight());
        }
        return res;
    }
}

