/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import java.util.List;
import java.util.Map;

public class CosineSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public CosineSimilarityImpl() {
    }

    public CosineSimilarityImpl(int levenshteinLimit) {
        super.setLevenshteinLimit(levenshteinLimit);
    }

    public double measureSimilarity(List<String> words1, List<String> words2) {
        if (words1.isEmpty() || words2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> wordFrequencies1 = this.countWordFrequency(words1);
        Map<String, Integer> wordFrequencies2 = this.countWordFrequency(words2);
        DoubleVector vectors = this.getProperVectors(wordFrequencies1, wordFrequencies2);
        double res = (double)VectorUtil.dotProduct(vectors.getVector1(), vectors.getVector2()) / (VectorUtil.magnitude(vectors.getVector1()) * VectorUtil.magnitude(vectors.getVector2()));
        logger.finest("Cosine similarity fully measured: " + res);
        return res;
    }
}

