/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import java.util.List;
import java.util.Map;

public class JensenShannonSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public JensenShannonSimilarityImpl() {
    }

    public JensenShannonSimilarityImpl(int levenshteinLimit) {
        super.setLevenshteinLimit(levenshteinLimit);
    }

    public double measureSimilarity(List<String> words1, List<String> words2) {
        if (words1.isEmpty() || words2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> wordFrequencies1 = this.countWordFrequency(words1);
        Map<String, Integer> wordFrequencies2 = this.countWordFrequency(words2);
        DoubleVector vectors = this.getProperVectors(wordFrequencies1, wordFrequencies2);
        double[] avg = new double[vectors.length()];
        for (int i = 0; i < avg.length; ++i) {
            avg[i] = (double)(vectors.getVector1()[i] + vectors.getVector2()[i]) / 2.0;
        }
        double res = (this.kullbackLieblerDivergence(vectors.getVector1(), avg) + this.kullbackLieblerDivergence(vectors.getVector2(), avg)) / 2.0;
        if ((res = 1.0 - res / 3.4) < 0.0) {
            res = 0.0;
        }
        logger.finest("Jensen-Shannon similarity fully measured: " + res);
        return res;
    }

    private double kullbackLieblerDivergence(int[] vector1, double[] vector2) {
        double res = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            if (vector1[i] == 0 || vector2[i] == 0.0) continue;
            res += (double)vector1[i] * Math.log(vector1[i]) - (double)vector1[i] * Math.log(vector2[i]);
        }
        return res;
    }
}

