/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.profile.inferred;

import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;

public class InferredConceptImpl
implements InferredConcept {
    private Set<RatedURI> ratedSemanticConcepts = new HashSet<RatedURI>();

    public InferredConceptImpl() {
    }

    public InferredConceptImpl(SortedSet<RatedURI> ratedSemanticConcepts) {
        this.ratedSemanticConcepts = ratedSemanticConcepts;
    }

    public void addRatedSemanticConcept(RatedURI ratedConcept) {
        if (this.ratedSemanticConcepts.contains(ratedConcept)) {
            for (RatedURI concept : this.ratedSemanticConcepts) {
                if (!ratedConcept.equals(concept)) continue;
                concept.setRate(Math.max(concept.getRate(), ratedConcept.getRate()));
                break;
            }
        } else {
            this.ratedSemanticConcepts.add(ratedConcept);
        }
    }

    public Set<RatedURI> getRatedSemanticConcepts() {
        return this.ratedSemanticConcepts;
    }

    public void removeRatedSemanticConcept(RatedURI ratedConcept) {
        this.ratedSemanticConcepts.remove(ratedConcept);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (RatedURI concept : this.ratedSemanticConcepts) {
            str.append(concept.toString() + ", ");
        }
        return "[" + str.toString() + "]";
    }
}

