/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.CompositionException;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchElementImpl;
import com.petalslink.easiersbs.matching.service.profile.SearchPartImpl;
import com.petalslink.easiersbs.matching.service.profile.SearchProfileImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredConceptImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import javax.xml.namespace.QName;

public class ProfileUtil {
    public static Set<RatedURI> getFlattenRatedUris(InferredElement element) {
        HashSet<InferredElement> listElements = new HashSet<InferredElement>();
        return ProfileUtil.getFlattenRatedUris(element, listElements);
    }

    private static Set<RatedURI> getFlattenRatedUris(InferredElement element, Set<InferredElement> listElements) {
        HashSet<RatedURI> res = new HashSet<RatedURI>();
        if (!listElements.contains(element)) {
            listElements.add(element);
            for (InferredConcept concept : element.getInferedSemanticConcepts()) {
                res.addAll(concept.getRatedSemanticConcepts());
            }
            for (InferredElement child : element.getChildElements()) {
                res.addAll(ProfileUtil.getFlattenRatedUris(child, listElements));
            }
        }
        return res;
    }

    public static SearchElement convertSemanticElement(SemanticElement element) {
        return ProfileUtil.convertSemanticElementHierarchy(element, new HashMap<QName, SearchElement>());
    }

    private static SearchElement convertSemanticElementHierarchy(SemanticElement elem, Map<QName, SearchElement> elementList) {
        SearchElementImpl res = new SearchElementImpl();
        res.setSemanticConcepts(elem.getSemanticConcepts());
        res.setElementQName(elem.getElementQName());
        res.setName(elem.getName());
        res.setRequired(elem.isRequired());
        elementList.put(elem.getElementQName(), res);
        for (SemanticElement child : elem.getChildElements()) {
            if (elementList.containsKey(child.getElementQName())) {
                res.addChildElement((GenericElement)elementList.get(child.getElementQName()));
                continue;
            }
            res.addChildElement((GenericElement)ProfileUtil.convertSemanticElementHierarchy(child, elementList));
        }
        return res;
    }

    public static InferredConcept inferConcept(URI concept, Reasoner reasoner, MatcherProperties props) {
        InferredConceptImpl inferedConcept;
        block6: {
            block5: {
                inferedConcept = new InferredConceptImpl();
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(concept, 1.0));
                if (!reasoner.isConcept(concept)) break block5;
                for (URI eqConcept : reasoner.getEquivalentClasses(concept)) {
                    if (reasoner.isThingOrNothing(eqConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqConcept, props.getEquivalentMark()));
                }
                Set specConcepts = reasoner.getSubClasses(concept);
                specConcepts.addAll(reasoner.getIndividuals(concept));
                for (URI specConcept : specConcepts) {
                    if (reasoner.isThingOrNothing(specConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(specConcept, props.getSpecializationMark()));
                }
                for (URI genConcept : reasoner.getSuperClasses(concept)) {
                    if (reasoner.isThingOrNothing(genConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
                }
                break block6;
            }
            if (!reasoner.isInstance(concept)) break block6;
            for (URI eqInstance : reasoner.getSimilarIndividuals(concept)) {
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqInstance, props.getEquivalentMark()));
            }
            for (URI genConcept : reasoner.getTypes(concept)) {
                if (reasoner.isThingOrNothing(genConcept)) continue;
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
            }
        }
        return inferedConcept;
    }

    public static Set<SemanticProfile> getSemanticProfiles(SortedSet<RatedSemanticProfile> ratedProfiles) {
        HashSet<SemanticProfile> res = new HashSet<SemanticProfile>();
        for (RatedSemanticProfile ratedProfile : ratedProfiles) {
            res.add(ratedProfile.getProfile());
        }
        return res;
    }

    public static SemanticProfile computeEquivalentProfile(Set<Operation> operations, SemanticRegistryManager registry, Reasoner reasoner, MatcherProperties props) throws CompositionException {
        HashMap<Operation, GenericElement> inputs = new HashMap<Operation, GenericElement>();
        HashMap<Operation, GenericElement> outputs = new HashMap<Operation, GenericElement>();
        HashMap<Operation, Set<Operation>> dependencies = new HashMap<Operation, Set<Operation>>();
        HashMap<QName, QName> elementMatchings = new HashMap<QName, QName>();
        SemanticProfileImpl res = new SemanticProfileImpl();
        res.setSemanticInterface((GenericPart)new SemanticPartImpl());
        res.setSemanticOperation((GenericPart)new SemanticPartImpl());
        for (Operation op : operations) {
            dependencies.put(op, new HashSet());
            SemanticProfile profile = registry.getSemanticProfile(op);
            if (profile.getInputSemanticElement() != null) {
                inputs.put(op, profile.getInputSemanticElement());
            }
            if (profile.getOutputSemanticElement() != null) {
                outputs.put(op, profile.getOutputSemanticElement());
            }
            res.addOperation(op);
            if (res.getPartner() == null) {
                res.setPartner(profile.getPartner());
            }
            ProfileUtil.combineSemanticParts((SemanticPart)res.getSemanticInterface(), (SemanticPart)profile.getSemanticInterface());
            ProfileUtil.combineSemanticParts((SemanticPart)res.getSemanticOperation(), (SemanticPart)profile.getSemanticOperation());
        }
        for (Operation op1 : operations) {
            if (inputs.get(op1) == null) continue;
            SearchElement input = ProfileUtil.convertSemanticElement((SemanticElement)inputs.get(op1));
            InferredElement infInput = input.infer(reasoner, props);
            for (Operation op2 : operations) {
                Map<QName, QName> matchElemOp1Op2;
                if (op1.equals(op2) || outputs.get(op2) == null || (matchElemOp1Op2 = SimilarityUtil.findElementMatchings(infInput, (SemanticElement)outputs.get(op2))).isEmpty()) continue;
                ((Set)dependencies.get(op1)).add(op2);
                elementMatchings.putAll(matchElemOp1Op2);
            }
        }
        if (ProfileUtil.hasCycle(dependencies)) {
            throw new CompositionException("There is a dependency loop between operations " + operations.toString());
        }
        res.setInputSemanticElement(ProfileUtil.createUncoveredElement(new HashSet(inputs.values()), elementMatchings.keySet(), SemanticElementImpl.class));
        res.setOutputSemanticElement(ProfileUtil.createUncoveredElement(new HashSet(outputs.values()), new HashSet<QName>(elementMatchings.values()), SemanticElementImpl.class));
        return res;
    }

    public static boolean hasCycle(Map<Operation, Set<Operation>> dependencies) {
        HashSet<Operation> independentNodes = new HashSet<Operation>();
        for (Map.Entry<Operation, Set<Operation>> entry : dependencies.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            independentNodes.add(entry.getKey());
        }
        while (!independentNodes.isEmpty()) {
            Operation op = (Operation)independentNodes.iterator().next();
            independentNodes.remove(op);
            for (Map.Entry<Operation, Set<Operation>> dependency : dependencies.entrySet()) {
                if (!dependency.getValue().remove(op) || !dependency.getValue().isEmpty()) continue;
                independentNodes.add(dependency.getKey());
            }
        }
        for (Set set : dependencies.values()) {
            if (set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static SearchProfile computeComplementaryProfile(SearchProfile initialProfile, SemanticProfile substractProfile, Reasoner reasoner, MatcherProperties props) {
        SearchProfileImpl res = new SearchProfileImpl();
        for (Operation op : substractProfile.getOperations()) {
            res.addOperation(op);
        }
        res.setSemanticInterface((GenericPart)ProfileUtil.substractPart((SearchPart)initialProfile.getSemanticInterface(), (SemanticPart)substractProfile.getSemanticInterface()));
        res.setSemanticOperation((GenericPart)ProfileUtil.substractPart((SearchPart)initialProfile.getSemanticOperation(), (SemanticPart)substractProfile.getSemanticOperation()));
        res.setInputSemanticElement((GenericElement)ProfileUtil.substractElement((SearchElement)initialProfile.getInputSemanticElement(), (SemanticElement)substractProfile.getInputSemanticElement(), reasoner, props));
        res.setOutputSemanticElement((GenericElement)ProfileUtil.substractElement((SearchElement)initialProfile.getOutputSemanticElement(), (SemanticElement)substractProfile.getOutputSemanticElement(), reasoner, props));
        return res;
    }

    private static SearchPart substractPart(SearchPart initialPart, SemanticPart part) {
        if (initialPart != null) {
            SearchPartImpl res = new SearchPartImpl();
            res.setName(initialPart.getName());
            for (URI concept : initialPart.getSemanticConcepts()) {
                if (part != null) {
                    if (part.getSemanticConcepts().contains(concept)) continue;
                    res.addSemanticConcept(concept);
                    continue;
                }
                res.addSemanticConcept(concept);
            }
            return res;
        }
        return null;
    }

    private static SearchElement substractElement(SearchElement initElem, SemanticElement elem, Reasoner reasoner, MatcherProperties props) {
        if (initElem != null) {
            if (elem == null) {
                return initElem;
            }
            InferredElement infInit = initElem.infer(reasoner, props);
            Map<QName, QName> matchInput = SimilarityUtil.findElementMatchings(infInit, elem);
            return ProfileUtil.createUncoveredElement(initElem, matchInput.keySet(), new HashSet(), SearchElementImpl.class);
        }
        return null;
    }

    private static void combineSemanticParts(SemanticPart part1, SemanticPart part2) {
        if (part2 != null) {
            part1.setName(part1.getName() + "-" + part2.getName());
            for (URI concept : part2.getSemanticConcepts()) {
                part1.addSemanticConcept(concept);
            }
        }
    }

    private static <E extends GenericElement<E>, EImpl extends E> E createUncoveredElement(Set<E> elements, Set<QName> elementToDelete, Class<EImpl> type) {
        HashSet<GenericElement> results = new HashSet<GenericElement>();
        for (GenericElement element : elements) {
            HashSet usedElements;
            GenericElement compElem = ProfileUtil.createUncoveredElement(element, elementToDelete, usedElements = new HashSet(), type);
            if (compElem == null) continue;
            results.add(compElem);
        }
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return (E)((GenericElement)results.iterator().next());
        }
        GenericElement res = null;
        try {
            res = (GenericElement)type.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        res.setElementQName(new QName("generated", UUID.randomUUID().toString()));
        res.setName("generatedElement");
        for (GenericElement child : results) {
            res.addChildElement(child);
        }
        return (E)res;
    }

    private static <E extends GenericElement<E>, EImpl extends E> E createUncoveredElement(E element, Set<QName> elementToDelete, Set<E> usedElements, Class<EImpl> type) {
        if (!element.isRequired() || elementToDelete.contains(element.getElementQName())) {
            return null;
        }
        E res = ProfileUtil.cloneElementWithoutHierarchy(element, type);
        if (element.hasChildElement() && !usedElements.contains(element)) {
            usedElements.add(element);
            HashSet<GenericElement> uncoveredChildren = new HashSet<GenericElement>();
            for (GenericElement child : element.getChildElements()) {
                GenericElement compElem = ProfileUtil.createUncoveredElement(child, elementToDelete, usedElements, type);
                if (compElem == null) continue;
                uncoveredChildren.add(compElem);
            }
            if (uncoveredChildren.isEmpty()) {
                return null;
            }
            for (GenericElement child : uncoveredChildren) {
                res.addChildElement(child);
            }
        }
        return res;
    }

    private static <E extends GenericElement<E>, EImpl extends E> E cloneElementWithoutHierarchy(E elem, Class<EImpl> type) {
        GenericElement res = null;
        try {
            res = (GenericElement)type.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        res.setName(elem.getName());
        res.setElementQName(elem.getElementQName());
        for (URI concept : elem.getSemanticConcepts()) {
            res.addSemanticConcept(concept);
        }
        return (E)res;
    }
}

